% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateK.R
\name{updateK}
\alias{updateK}
\title{Update the cluster membership vector.}
\usage{
updateK(G, K, z, mu, sigma2, Id, lambda)
}
\arguments{
\item{G}{The number of clusters being fitted.}

\item{K}{The cluster membership vector.}

\item{z}{The n x d matrix of latent locations.}

\item{mu}{The G x d matrix of cluster means.}

\item{sigma2}{The G vector of cluster covariances.}

\item{Id}{An identity matrix of dimension d.}

\item{lambda}{The n x G matrix of mixing proportions.}
}
\value{
The cluster membership vector.
}
\description{
A Gibbs update step for K, the cluster membership vector.
}
\references{
Isobel Claire Gormley and Thomas Brendan Murphy. (2010) A Mixture of Experts Latent Position Cluster Model for Social Network Data. Statistical Methodology, 7 (3), pp.385-405.
}
\seealso{
\code{\link{MEclustnet}}
}
