% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary-plot.R
\name{base_aquatic_stage}
\alias{base_aquatic_stage}
\title{Base Aquatic Function for Erlang-Stage Summary}
\usage{
base_aquatic_stage(out, spn_P, elp)
}
\arguments{
\item{out}{the output of \code{\link[MGDrivE2]{sim_trajectory_R}}}

\item{spn_P}{the places of the SPN, see details}

\item{elp}{stage to summarize, one of: "egg", "larvae", "pupae"}
}
\value{
a 3 to 5 column dataframe for plotting with ggplot2
}
\description{
This function takes a given aquatic (egg, larval, pupal) stage and sums over
the genotypes, returning summary trajectories by Erlang-distributed stage.
}
\details{
This function is the base function for \code{\link{summarize_eggs_stage}},
\code{\link{summarize_larvae_stage}}, and \code{\link{summarize_pupae_stage}}.

The places (\code{spn_P}) object is generated from one of the following:
\code{\link{spn_P_lifecycle_node}}, \code{\link{spn_P_lifecycle_network}},
\code{\link{spn_P_epiSIS_node}}, \code{\link{spn_P_epiSIS_network}},
\code{\link{spn_P_epiSEIR_node}}, or \code{\link{spn_P_epiSEIR_network}}.

The return object depends on the data provided. If the simulation was only 1 node,
then no \code{node} designation is returned. If only one repetition was performed,
no \code{rep} designation is returned. Columns always returned include: \code{time},
\code{Erlang-stage}, and \code{value}.
}
\keyword{internal}
