% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIDASim.R
\name{MIDASim}
\alias{MIDASim}
\title{Simulating Realistic Microbiome Data using MIDASim}
\usage{
MIDASim(fitted.modified, only.rel = FALSE)
}
\arguments{
\item{fitted.modified}{Output from MIDASim.modify.}

\item{only.rel}{A logical indicating whether to only simulate relative-
abundance data. If \code{TRUE}, then the count data will not be generated.
Defaults to \code{FALSE}.}
}
\value{
Returns a list that has components:
\item{sim_01}{Matrix of simulated presence-absence data}
\item{sim_rel}{Matrix of simulated relative-abundance data}
\item{sim_count}{Matrix of simulated count data}
}
\description{
Generate microbiome datasets using parameters from MIDASim.modify.
}
\examples{

\donttest{
  data("throat.otu.tab")
  otu.tab = throat.otu.tab[,colSums(throat.otu.tab>0)>1]

  fitted = MIDASim.setup(otu.tab)
  fitted.modified = MIDASim.modify(fitted)
  sim = MIDASim(fitted.modified, only.rel = FALSE)
}

}
\author{
Mengyu He
}
