% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{SD_data}
\alias{SD_data}
\title{Job postings dataset}
\format{
\subsection{\code{SD_data}}{

A data frame with 16315 rows and 6 columns:
\describe{
\item{city_name}{Character. City of the job posting}
\item{naics_2022_2}{Character. Type of business (NAICS industry classification)}
\item{salary}{Numeric. Salary offered (response variable)}
\item{wfh_wham}{Numeric. Binary label generated via ML, indicating whether
remote work is offered (subject to measurement error)}
\item{soc_2021_2}{Character. Occupation code (SOC classification)}
\item{employment_type_name}{Character. Employment type (part time/full time)}
}
}
}
\source{
Proprietary data from Lightcast job postings platform
}
\usage{
SD_data
}
\description{
A subset of data relating to job postings on the Lightcast platform
for demonstrating bias correction methods with ML-generated variables.
}
\examples{
\dontrun{
data(SD_data)
fit <- ols_bca(log(salary) ~ wfh_wham + soc_2021_2 + naics_2022_2,
               data = SD_data, fpr = 0.009, m = 1000)
}
}
\keyword{datasets}
