\name{Column-wise MLE of distributions defined in the (0, 1) interval}
\alias{colprop.mle}
\title{
Column-wise MLE of distributions defined in the (0, 1) interval
}

\description{
Column-wise MLE of distributions defined in the (0, 1) interval.
}

\usage{
colprop.mle(x, distr = "beta", tol = 1e-07, maxiters = 100, parallel = FALSE)
}

\arguments{
\item{x}{
A numerical vector with proportions, i.e. numbers in (0, 1) (zeros and ones are not allowed).
}
\item{distr}{
The distribution to fit. "beta" stands for the beta distribution, "logitnorm" is the logistic normal, "unitweibull" is the unit-Weibull and the "sp" is the standard power distribution, "ibeta" is the inflated beta, (0-inflated or 1-inflated, depending on the data), "hsecant01" stands for the hyper-secant, "kumar" is the Kumaraswamy, "simplex" is the simplex distribution, "zil" is the zero inflated logistic normal, "cbern" is the continuous Bernoulli distribution, and "logisbeta" is the logistic-beta distribution.
}
\item{tol}{
The tolerance level up to which the maximisation stops.
}
\item{maxiters}{
The maximum number of iterations the Newton-Raphson will perform.
}
\item{parallel}{
Should the computations take place in parallel? This is for the "spml" only.
}
}

\details{
Maximum likelihood estimation of the parameters of the beta distribution is performed via Newton-Raphson.
The distributions and hence the functions does not accept zeros. "logitnorm.mle" fits the logistic normal,
hence no nwewton-Raphson is required and the "hypersecant01.mle" uses the golden ratio
search as is it faster than the Newton-Raphson (less calculations).
}

\value{
A matrix with two, columns. The first one contains the parameters of the distribution
and the second columns contains the log-likelihood values.
}

\references{
N.L. Johnson, S. Kotz and N. Balakrishnan (1994). Continuous Univariate Distributions, Volume 1 (2nd Edition).

N.L. Johnson, S. Kotz and N. Balakrishnan (1970). Distributions in statistics: continuous univariate distributions, Volume 2.

Kumaraswamy P. (1980). A generalized probability density function for double-bounded
random processes. Journal of Hydrology 46(1-2): 79--88.

Jones M.C. (2009). Kumaraswamy's distribution: A beta-type distribution with some
tractability advantages. Statistical Methodology, 6(1): 70--81.

J. Mazucheli, A. F. B. Menezes, L. B. Fernandes, R. P. de Oliveira and M. E. Ghitany (2020).
The unit-Weibull distribution as an alternative to the Kumaraswamy distribution for the modeling of quantiles conditional on covariates. Journal of Applied Statistics, 47(6): 954--974.

Leemis L.M. and McQueston J.T. (2008). Univariate Distribution Relationships.
The American Statistician, 62(1): 45--53.

You can also check the relevant wikipedia pages.
}


\author{
Michail Tsagris, Sofia Piperaki and Rafail Vargiakakis.

R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr}, Sofia Piperaki  \email{sofiapip23@gmail.com} and Rafail Vargiakakis \email{rafailvargiakakis@gmail.com}.
}

%\note{
%%  ~~further notes~~
%}

\seealso{
\code{ \link{prop.mle}, \link{positive.mle}
}
}

\examples{
x <- rbeta(1000, 1, 4)
prop.mle(x, distr = "beta")
}
