#' An example of joined national forest inventory and site data that is used
#' within the MLFS
#'
#' This is simulated data that reassemble the national forest inventory data.
#' We use it to show how to run examples for predicting tree mortality.
#' Mortality occurs in the middle of a simulation step, so all variables have
#' the preposition 'mid'
#'
#' @format A data frame with 6855 rows and 41 variables:
#' \describe{
#'   \item{year}{year in which plot was visited}
#'   \item{plotID}{a unique identifier for plot}
#'   \item{treeID}{a unique identifier for tree}
#'   \item{speciesGroup}{identifier for species group}
#'   \item{code}{status of a tree: 0 (normal), 1(harvested), 2(dead), 3 (ingrowth)}
#'   \item{species}{species name}
#'   \item{slope}{slope on a plot}
#'   \item{elevation}{plot elevation}
#'   \item{northness}{plot northness, 1 is north, 0 is south}
#'   \item{siteIndex}{a proxy for site index, higher value represents more productive sites}
#'   \item{p_sum}{monthly precipitation sum}
#'   \item{t_avg}{monthly mean temperature}
#'   \item{BA_mid}{basal area of individual trees in m2 in the middle of a simulation step}
#'   \item{BAI_mid}{basal area increment in the middle of a simulation step}
#'   \item{weight_mid}{upscale weight to calculate hectare values in the middle of a simulation step}
#'   \item{height_mid}{tree height in meters in the middle of a simulation step}
#'   \item{crownHeight_mid}{crown height in meters in the middle of a simulation step}
#'   \item{volume_mid}{tree volume in m3 in the middle of a simulation step}
#'   \item{BAL_mid}{Basal Area in Large trees the middle of a simulation step}
#'   \item{stand_BA_mid}{Total stand basal area the middle of a simulation step}
#'   \item{stand_n_mid}{The number of trees in a stand the middle of a simulation step}
#'
#' }
#' @export
"data_v4"
