% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pugs.R
\name{validate_pugs}
\alias{validate_pugs}
\title{Assess multi-label prediction accuracy}
\usage{
validate_pugs(object, y)
}
\arguments{
\item{object}{A \code{PUGS} object generated by \code{\link{predict.ECC}}.}

\item{y}{A matrix of the same form as the one used with
\code{\link{ecc}}.}
}
\value{
A variety of multi-label classification accuracy measurements.
}
\description{
Computes a variety of accuracy metrics for multi-label
  predictions.
}
\examples{
x <- movies_train[, -(1:3)]
y <- movies_train[, 1:3]

model_glm <- ecc(x, y, m = 1, .f = glm.fit, family = binomial(link = "logit"))

predictions_glm <- predict(model_glm, movies_test[, -(1:3)],
.f = function(glm_fit, newdata) {

  # Credit for writing the prediction function that works
  # with objects created through glm.fit goes to Thomas Lumley
  
  eta <- as.matrix(newdata) \%*\% glm_fit$coef
  output <- glm_fit$family$linkinv(eta)
  colnames(output) <- "1"
  return(output)
  
}, n.iters = 10, burn.in = 0, thin = 1)

validate_pugs(predictions_glm, movies_test[, 1:3])

\dontrun{

model_c50 <- ecc(x, y, .f = C50::C5.0)
predictions_c50 <- predict(model_c50, movies_test[, -(1:3)],
                           n.iters = 10, burn.in = 0, thin = 1,
                           .f = C50::predict.C5.0, type = "prob")
validate_pugs(predictions_c50, movies_test[, 1:3])
  
model_rf <- ecc(x, y, .f = randomForest::randomForest)
predictions_rf <- predict(model_rf, movies_test[, -(1:3)],
                          n.iters = 10, burn.in = 0, thin = 1,
                          .f = function(rF, newdata){
                            randomForest:::predict.randomForest(rF, newdata, type = "prob")
                          })
validate_pugs(predictions_rf, movies_test[, 1:3])
}
}

