% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMLR.R
\name{Ysimulation}
\alias{Ysimulation}
\title{Simulation of the vector of responses Y. Data preparation stage for simulation.}
\usage{
Ysimulation(t, I, X, lambda, sigma = 1, beta)
}
\arguments{
\item{t}{Vector of the observed time (n x 1), n – number of observations}

\item{I}{Vector of the initial states (n x 1), n – number of observations}

\item{X}{Matrix of predictors (n x k), n - number of observations, k - number of columns (k - 1 - number of regressors).}

\item{lambda}{Matrix with the known transition rates  \eqn{\lambda_{i,j}}, (m x m), m – number of states}

\item{sigma}{Scalar, the standard deviation of the disturbance term}

\item{beta}{Matrix (k x m), k - number of columns (k - 1 - number of regressors), m - number of states, m = 2,3,.. .}
}
\value{
Vector with new response values of vector Y (n x 1)
}
\description{
Additional function to be used for simulation purposes (academical or research).
Simulating the vector of responses Y according to the formula (see details).
}
\details{
The i-th response $Y_{i}$ is defined by the following formula: $Y_{i}(t)=x_{i}\eqn{\beta} + Z_{i} sqrt{t}, i=1,...,n.$
The vector with stationary probabilities is user-defined vector.
}
\examples{
Xtest <- cbind(rep_len(1,10),c(2,5,7,3,1,1,2,2,3,6), c(5,4,1,2,3,2,3,5,2,2))
tGiven <- matrix (c(0.9,1.18,1,1.6,1.4,1.7,1.9,1.45,1.5,2.14), nrow = 10, ncol = 1)
initState <- matrix (c(2,1,1,2,2,2,1,1,2,1),nrow = 10, ncol = 1)
lambda <- matrix(c(0, 0.33, 0.45, 0), nrow = 2, ncol = 2, byrow = TRUE)
beta <- matrix(c(1, 2, 3, 4, 6, 8), nrow = 3, ncol = 2, byrow = TRUE)
Ysimulation(tGiven,initState,Xtest,lambda,1,beta)
}
