#' @title Get the groups created by the clustStruct function
#' @name trueGroups
#' @description Get the unique groups generated by the \link[MMOC]{clustStruct} function for a given `k`. The number of rows of the resulting matrix gives the number of unique groups.
#'
#' @param n An integer, the sample size for all generated data sets
#' @param k An integer or vector, the number of distinct clusters in each generated data set. `n/k` must be an integer for all values of `k`
#'
#' @returns A matrix with the unique groups/clusters from the multi-view data generated from \link[MMOC]{clustStruct}. The final column `Grps` enumerates these groups.
#' @examples
#'
#' trueGroups(n=120, k=c(2,3,4))
#'
#' @export
trueGroups <- function(n,k){
  grps <- getGroups(n,k)
  uGrp <- unique(grps)

  grpN <- cbind(uGrp, Grps=1:nrow(uGrp))
  unique( merge(grps, grpN) )
}
