% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_moead.R
\name{summary.moead}
\alias{summary.moead}
\title{summary.moead}
\usage{
\method{summary}{moead}(
  object,
  ...,
  useArchive = FALSE,
  viol.threshold = 1e-06,
  ndigits = 3,
  ref.point = NULL,
  ref.front = NULL
)
}
\arguments{
\item{object}{list object of class \emph{moead}
(generated by \code{\link[=moead]{moead()}})}

\item{...}{other parameters to be passed down to specific summary functions (currently unused)}

\item{useArchive}{logical flag to use information from \code{object$Archive}.
Only used if object$Archive is not \code{NULL}.}

\item{viol.threshold}{threshold of tolerated constraint violation, used to
determine feasibility of points in \code{object}.}

\item{ndigits}{number of decimal places to use for the ideal and nadir estimates}

\item{ref.point}{reference point for calculating the dominated hypervolume
(only if package \code{emoa} is available). If \code{NULL} the estimated nadir
point is used instead.}

\item{ref.front}{\verb{Np x Nobj} matrix containing a sample of the true Pareto-optimal
front, for calculating IGD.}
}
\description{
S3 method for summarizing \emph{moead} objects (the output of \code{\link[=moead]{moead()}}).
}
\section{References}{

F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr
}

\examples{
problem.1 <- list(name = "example_problem",
                  xmin = rep(-1,30),
                  xmax = rep(1,30),
                  m    = 2)
out <- moead(preset    = preset_moead("original2"),
             problem   = problem.1,
             stopcrit  = list(list(name = "maxiter",
                                   maxiter = 100)),
             showpars  = list(show.iters = "dots",
                              showevery  = 10))
summary(out)

}
