% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma.est.R
\name{gamma_est}
\alias{gamma_est}
\title{Method of Moments Estimation of Gamma distribution}
\usage{
gamma_est(
  data,
  unknown = c("shape", "scale", "both"),
  shape = NULL,
  scale = NULL,
  plot = TRUE,
  curvecol = "red",
  ...
)
}
\arguments{
\item{data}{A numeric vector.}

\item{unknown}{A character string specifying which parameter is (are) unknown to the user.}

\item{shape, scale}{positive shape and scale parameters of the gamma distribution.}

\item{plot}{logical which controls whether the histogram of the data along with the density curve of the theoretical gamma distribution with the estimated parameters.}

\item{curvecol}{color of the theoretical density curve}

\item{...}{additional plotting parameters}
}
\value{
the estimated parameters by the method of moments of the data assuming the underlying distribution is gamma distribution
}
\description{
function to get the method of moment estimate(s) of gamma distribution
}
\examples{
gamma_est(rgamma(1000,shape=2,scale=1),unknown="scale",shape=2)#shape is known
gamma_est(rgamma(1000,shape=2,scale=1),unknown="shape",scale=1)#scale is known
gamma_est(rgamma(1000,shape=2,scale=1),unknown="both")#both will be estimated
}
