% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnorm.est.R
\name{lnorm_est}
\alias{lnorm_est}
\title{Method of Moments Estimation of Log-Normal distribution}
\usage{
lnorm_est(
  data,
  unknown = c("meanlog", "sdlog", "both"),
  meanlog = NULL,
  sdlog = NULL,
  plot = TRUE,
  curvecol = "red",
  ...
)
}
\arguments{
\item{data}{A numeric vector.}

\item{unknown}{A character string specifying which parameter is (are) unknown to the user.}

\item{meanlog, sdlog}{mean and standard deviation of the distribution on the log scale.}

\item{plot}{logical which controls whether the histogram of the data along with the density curve of the theoretical log normal distribution with the estimated parameters.}

\item{curvecol}{color of the theoretical density curve}

\item{...}{additional plotting parameters}
}
\value{
the estimated parameters by the method of moments of the data assuming the underlying distribution is log normal distribution
}
\description{
function to get the method of moment estimate(s) of log-normal distribution
}
\examples{
lnorm_est(rlnorm(1000),unknown="meanlog",sdlog=1)#meanlog unknown, but sdlog known
lnorm_est(rlnorm(1000),unknown="sdlog",meanlog=0)#sdlog unknown, but meanlog known
lnorm_est(rlnorm(1000),unknown="both")#both will be estimated
}
