% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta.ind.t.R
\name{delta.ind.t}
\alias{delta.ind.t}
\title{d-delta for Between Subjects with Control Group SD Denominator}
\usage{
delta.ind.t(m1, m2, sd1, sd2, n1, n2, a = 0.05)
}
\arguments{
\item{m1}{mean from control group}

\item{m2}{mean from experimental group}

\item{sd1}{standard deviation from control group}

\item{sd2}{standard deviation from experimental group}

\item{n1}{sample size from control group}

\item{n2}{sample size from experimental group}

\item{a}{significance level}
}
\value{
Provides the effect size (Cohen's d) with associated confidence intervals,
the t-statistic, the confidence intervals associated with the means of each group, as well as the
standard deviations and standard errors of the means for each group.

\item{d}{d-delta effect size}
\item{dlow}{lower level confidence interval of d-delta value}
\item{dhigh}{upper level confidence interval of d-delta value}
\item{M1}{mean of group one}
\item{sd1}{standard deviation of group one mean}
\item{se1}{standard error of group one mean}
\item{M1low}{lower level confidence interval of group one mean}
\item{M1high}{upper level confidence interval of group one mean}
\item{M2}{mean of group two}
\item{sd2}{standard deviation of group two mean}
\item{se2}{standard error of group two mean}
\item{M2low}{lower level confidence interval of group two mean}
\item{M2high}{upper level confidence interval of group two mean}
\item{spooled}{pooled standard deviation}
\item{sepooled}{pooled standard error}
\item{n1}{sample size of group one}
\item{n2}{sample size of group two}
\item{df}{degrees of freedom (n1 - 1 + n2 - 1)}
\item{t}{t-statistic}
\item{p}{p-value}
\item{estimate}{the d statistic and confidence interval in
APA style for markdown printing}
\item{statistic}{the t-statistic in APA style for markdown printing}
}
\description{
This function displays d-delta for between subjects data
and the non-central confidence interval using the
control group standard deviation as the denominator.
}
\details{
To calculate d-delta, the mean of the experimental group
is subtracted from the mean of the control group, which
is divided by the standard deviation of the control group.

d_delta = (m1 - m2) / sd1

\href{https://www.aggieerin.com/shiny-server/tests/indtdelta.html}{Learn more on our example page.}
}
\examples{

#The following example is derived from the "indt_data" dataset, included
#in the MOTE library.

#A forensic psychologist conducted a study to examine whether
#being hypnotized during recall affects how well a witness
#can remember facts about an event. Eight participants
#watched a short film of a mock robbery, after which
#each participant was questioned about what he or she had
#seen. The four participants in the experimental group
#were questioned while they were hypnotized. The four
#participants in the control group recieved the same
#questioning without hypnosis.

    hyp = t.test(correctq ~ group, data = indt_data)

#You can type in the numbers directly, or refer to the dataset,
#as shown below.

    delta.ind.t(m1 = 17.75, m2 = 23,
               sd1 = 3.30, sd2 = 2.16,
                n1 = 4, n2 = 4, a = .05)

    delta.ind.t(17.75, 23, 3.30, 2.16, 4, 4, .05)

    delta.ind.t(mean(indt_data$correctq[indt_data$group == 1]),
            mean(indt_data$correctq[indt_data$group == 2]),
            sd(indt_data$correctq[indt_data$group == 1]),
            sd(indt_data$correctq[indt_data$group == 2]),
            length(indt_data$correctq[indt_data$group == 1]),
            length(indt_data$correctq[indt_data$group == 2]),
            .05)

#Contrary to the hypothesized result, the group that underwent hypnosis were
#significantly less accurate while reporting facts than the control group
#with a large effect size, t(6) = -2.66, p = .038, d_delta = 1.59.

}
\keyword{delta,}
\keyword{effect}
\keyword{independent}
\keyword{size,}
\keyword{t}
