% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{bce}
\alias{bce}
\title{bce Baranov catch equation}
\usage{
bce(M, Fat, Nt, ages)
}
\arguments{
\item{M}{instantaneous rate of natural mortality, assumed constant}

\item{Fat}{a vector of age-specific instantaneous rates of fishing
mortality over the time period t, this is usually estimated by
multiplying the fully selected F by the selectivity/availability
at age.}

\item{Nt}{The population numbers-at-age at the start of time t}

\item{ages}{the ages 0:maxage used in the calculations}
}
\value{
a matrix of surviving numbers-at age, total mortality-at-age, and 
    catch-at-age
}
\description{
bce the Baranov Catch Equation. The total mortality of
    fish in an exploited population is made up of fish being killed 
    by fishing and others dying naturally. We use the bce to estimate 
    the catch (those killed by fishing). The bce has value because some 
    fish that would be expected to die naturally can be expected to 
    be caught and killed by fishing, so estimating the catch is 
    rather more complex than numbers of fish available times the 
    harvest rate, Nt x Ht. If is possible to use the Baranov Catch Equation 
    when calculating the expected catches then it is usually better to do so.
}
\examples{
age <- 0:25
Ft <- -log(1 - 0.2) # harvest rate of 0.2
Faa <- rep(Ft,length(age))
M <- 0.12
Nt <- 1000
bce(M,Fat=Faa,Nt,ages=age)   # should give 188.8862
}
