% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeOfBlobs.R
\name{quartetCutTest}
\alias{quartetCutTest}
\title{Hypothesis test for quartet counts fitting a resolved quartet tree of blobs under NMSC}
\usage{
quartetCutTest(
  obs,
  lambda = 0,
  method = "MLest",
  smallcounts = "approximate",
  bootstraps = 10^4
)
}
\arguments{
\item{obs}{vector of 3 counts of resolved quartet frequencies}

\item{lambda}{parameter for power-divergence statistic (e.g., 0 for likelihood ratio statistic, 1 for Chi-squared statistic)}

\item{method}{\code{"MLtest"},\code{"conservative"}, or \code{"bootstrap"}}

\item{smallcounts}{\code{"bootstrap"} or \code{"approximate"}, method of obtaining p-value when some counts are small}

\item{bootstraps}{number of samples for bootstrapping}
}
\value{
output where \code{output$p.value} is a p-value and \code{output$topology} = 1, 2, or 3
indicates the ML estimate of the topology of the quartet tree of blobs in accord with ordering of qcCF entries.
}
\description{
Test the hypothesis H_0=Cut model of \insertCite{ABMR24;textual}{MSCquartets},
Section 3., vs. H_1= everything else.
Returns p-value and estimate of tree of blobs topology.
}
\details{
The Cut model for quartet CFs is the NMSC combined with the quartet species network having
a cut edge separating two of the taxa from the other two.

This function implements the test described in \insertCite{ABMR24;textual}{MSCquartets}
as well as parametric bootstrapping,
with other procedures for when some expected counts are small.
These are more accurate tests than, say, a Chi-square with one degree of freedom,
which is not theoretically
justified near the singularity of the model, nor for small counts.

If \code{method="MLtest"}, this uses the test for the Cut model described
in Section 3 of \insertCite{ABMR24;textual}{MSCquartets}, using the ML
estimate of the generating parameter.
As shown in simulations in that paper, the test is conservative when small
levels are used for rejection.
Although the test generally performs well in practice, it lacks a uniform
asymptotic guarantee over the full parameter space.

If \code{method="conservative"}, the test uses the Chi-square distribution with 1 degree of freedom
(the "least favorable" approach). This is asymptotically guaranteed to reject the null
hypothesis at most at a specified level, but at the expense of increased type II errors.

If \code{method="bootstrap"}, then parametric bootstrapping is performed,
based on ML estimates of the CF. The bootstrap sample size is given by the \code{bootstrap} argument.

When some expected topology counts are small, the methods \code{"MLest"} and \code{"conservative"}
are not appropriate.
The argument \code{smallcounts} determines whether bootstrapping or a faster approximate method is used.
These use ML estimates of the CF under the Cut model.

If two of the three counts are small (so the estimated CF is near a vertex of the simplex),
The approximate approach
returns a precomputed p-value, found by replacing the largest observed count
with 1e+6 and performing 1e+8 bootstraps. When n is sufficiently large (at least 30) and
some expected counts are small, the probability of topological error  is small and the bootstrap p-value is
approximately independent of the largest observed count.

If one of the three counts is small (so the estimated CF is near an edge of the simplex),
a chi-squared test using the binomial model for the larger counts is used, as described
by \insertCite{ABMR24;textual}{MSCquartets}.

The returned p-value should be taken with caution when there is a small sample size, e.g. less than 30 gene trees.
}
\examples{
 quartetCutTest(c(17,72,11))
 quartetCutTest(c(48,11,41))
 quartetCutTest(c(11,48,41))
 quartetCutTest(c(48,41,11))

}
\references{
\insertRef{ABMR22}{MSCquartets}

\insertRef{ABMR24}{MSCquartets}

\insertRef{MAR19}{MSCquartets}
}
\seealso{
\code{\link{quartetCutTestInd}}
}
