% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kurt.R
\name{kurt}
\alias{kurt}
\title{Compute Sample Kurtosis}
\usage{
kurt(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
A single numeric value representing the kurtosis
}
\description{
Calculates the kurtosis of a numeric vector.
A value near 0 suggests normal kurtosis (mesokurtic),
positive values indicate heavier tails (leptokurtic), and negative
values indicate lighter tails (platykurtic).
}
\details{
The z-scores are computed as:
\deqn{z_i = \frac{x_i - \bar{x}}{sd}}

The kurtosis is then calculated as:
\deqn{\text{Kurtosis} = \frac{1}{n} \sum_{i=1}^{n} z_i^4 - 3}

Where:
\itemize{
\item \eqn{\bar{x}} is the mean of \eqn{x},
\item \eqn{sd} is the standard deviation of \eqn{x},
\item and \eqn{n} is the number of observations.
}
}
\examples{
# Kurtosis of mpg in mtcars
data("mtcars")
kurt(mtcars$mpg)


}
