% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bmi.R
\name{plotbmi}
\alias{plotbmi}
\title{Plots BMI z-scores and percentiles on references curves.}
\usage{
plotbmi(
  age,
  sex,
  bmi,
  lwd = 1,
  age_range = "0-24",
  line.color = "skyblue",
  graphtype = "z-scores",
  size.label = 2,
  size.score = 4,
  line.type = "solid",
  shape = 2,
  Notes = FALSE
)
}
\arguments{
\item{age}{a numeric value (in months) from 0 to 228 depending on the age_range.}

\item{sex}{preferably numeric (1 = Male, 2 = Female).
Strings (such as "Male", "Female") can also be used.}

\item{bmi}{a numeric value in kilograms per meter squared (kg/m^2).}

\item{lwd}{Line width allows you to specify a numeric value that control the
width of the line plots. By dafult, it is set to 1.}

\item{age_range}{age range in months. Input has to be characters.
It allows "0-24" by default. Other inputs allowed are "24-60" or "61-228".}

\item{line.color}{The color of the lines. It is set to "skyblue" by default.}

\item{graphtype}{A character input is required: "z-scores" or "percentiles".}

\item{size.label}{size of the label for calculated z-score or percentile}

\item{size.score}{refers to the size of the text for the calculated z-scores
(-3,-2,-1,0,1,2,3) or the percentiles.}

\item{line.type}{Type of line such as: "solid", "dotted",
"dashed", "blank", "dotdash", "twodash", "longdash"}

\item{shape}{of the individual point (marker)}

\item{Notes}{Is FALSE by default. If set to TRUE, 'notes' will be printed on
the console about the nature, range of variables allowed and number of records processed.}
}
\value{
Plots z-scores or percentiles with a mark indicating where the individual
person lies within the standardized reference curves.
}
\description{
Plots BMI z-scores and percentiles on standardized growth references
 using the LMS method for children and adolescents aged 0 to 19 years.
}
\examples{
g1 <- plotbmi(age = 6, sex = 2, bmi = 18.5) # plots Z-scores

g2 <- plotbmi(age = 6, sex = 2, bmi = 18.5, graphtype = "percentiles")

g3 <- plotbmi(age = c(25, 36, 48, 60), sex = 2, bmi = c(15.7, 16.8, 20.6, 12.7),
      age_range = "24-60")

g4 <- plotbmi(age = c(61, 73, 181, 217), sex = 1, bmi = c(12.1, 14.1, 27.1, 35.4),
      age_range = "61-228", graphtype = "percentiles")

}
\references{
<https://www.who.int/childgrowth/standards/bmi_for_age/en/>

<https://www.who.int/growthref/who2007_bmi_for_age/en/>

<https://www.who.int/childgrowth/standards/Technical_report.pdf>
}
\seealso{
\code{\link{indivmuaczs}}, \code{\link{muaczs}}, \code{\link{bmizs}}, \code{\link{muacz.bmiz}} and \code{\link{plotmuac}}.
}
