% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{AdaptiveNormalization}
\alias{AdaptiveNormalization}
\title{Objective space normalization.}
\usage{
AdaptiveNormalization(objectiveValue)
}
\arguments{
\item{objectiveValue}{Set of objective vectors to normalize}
}
\value{
A list containing the following:
\code{normalizedObjective} The normalized values
\code{idealPoint} The ideal point corresponding to the origin
\code{nadirPoint} The location of nadir point in the normalized Space
}
\description{
Normalize the objectives to 0-1. The origin is the ideal point. (1,...,1) is not the nadir point.
The normalization is done by using adaptive normalization used in NSGA-III.
}
\examples{
nObj <- 5
nIndividual <- 100
nVar <- 10
population <- InitializePopulationLHS(nIndividual,nVar,FALSE)
objective <- matrix(,nrow=nObj,ncol=nIndividual)
for(individual in 1:nIndividual){
   objective[,individual] <- WFG4(population[,individual],nObj)
}
AdaptiveNormalization(objective)
}
