% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimentDesign.R
\name{experimentDesign}
\alias{experimentDesign}
\title{Step3: Generate the experimental design matrix.}
\usage{
experimentDesign(data, session = 1, randomItem = FALSE, randomEvent = FALSE)
}
\arguments{
\item{data}{A data frame that has been processed through the 'loadData' function, containing the experimental items and their attributes.}

\item{session}{An integer indicating how many sessions (the whole set of trials) should be run. Default is 1, meaning no repetition.}

\item{randomItem}{A logical indicating whether the Item should be randomized. Default is FALSE, meaning trials will occur in the order provided.}

\item{randomEvent}{A logical indicating whether the Event should be randomized. Default is FALSE, meaning trials will occur in the order provided.}
}
\value{
A data.frame with the designed structure for the experiment, including any repetitions and randomizations as specified. Each row corresponds to a single trial or instance in the experiment.And it will display the type of experiment with the materials you provide.
}
\description{
Defines the experiment setup based on the stimuli loaded.
}
\examples{

df <- data.frame(
Run = c(1,2),
Item = c(1,2),
Event= c(1,1),
Condition = c(1,2),
TargetPrompt = c("1","2")
)

ExperimentItem=loadData(df$Run,df$Item,df$Event,df$Condition,promptList = df$TargetPrompt)

Design=experimentDesign(ExperimentItem,session=1,randomItem=TRUE)

}
