% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Eigen.HMM_init.R
\name{Eigen.HMM_init}
\alias{Eigen.HMM_init}
\title{Initialization for ECM Algorithms in Matrix-Variate Hidden Markov Models}
\usage{
Eigen.HMM_init(
  Y,
  k,
  density,
  mod.row = "all",
  mod.col = "all",
  nstartR = 50,
  nThreads = 1,
  verbose = FALSE,
  seed = 3
)
}
\arguments{
\item{Y}{An array with dimensions \code{p} x \code{r} x \code{num} x \code{t}, where \code{p} is the number of
variables in the rows of each data matrix, \code{r} is the number of variables in the columns of each
data matrix, \code{num} is the number of data observations, and \code{t} is the number of time points.}

\item{k}{An integer or vector indicating the number of states in the model(s).}

\item{density}{A character string specifying the distribution to use in the HMM.
Possible values are: "MVN" for the matrix-variate normal distribution,
"MVT" for the matrix-variate t-distribution, and "MVCN" for the matrix-variate contaminated normal distribution.}

\item{mod.row}{A character string indicating the parsimonious structure of the row covariance (or scale) matrices.
Possible values are: "EII", "VII", "EEI", "VEI", "EVI", "VVI", "EEE", "VEE", "EVE", "EEV", "VVE", "VEV", "EVV", "VVV", or "all".
When "all" is specified, all 14 parsimonious structures are considered.}

\item{mod.col}{A character string indicating the parsimonious structure of the column covariance (or scale) matrices.
Possible values are: "II", "EI", "VI", "EE", "VE", "EV", "VV", or "all".
When "all" is specified, all 7 parsimonious structures are considered.}

\item{nstartR}{An integer specifying the number of random starts to consider.}

\item{nThreads}{A positive integer indicating the number of cores to use for parallel processing.}

\item{verbose}{A logical value indicating whether to display the running output.}

\item{seed}{A positive integer specifying the seed for random generation.}
}
\value{
A list containing the following elements:
\item{results}{A list of the results from the initialization.}
\item{k}{The number of states fitted in each model.}
\item{req.model}{A data frame listing the models that were initialized.}
\item{init.used}{A data frame listing the initializations used for the required models.}
\item{index}{A numeric vector to be used by the \code{Eigen.HMM_fit()} function.}
\item{dens}{The density used for the HMMs.}
}
\description{
Initializes the ECM algorithms used for fitting parsimonious matrix-variate Hidden Markov Models (HMMs).
Parallel computing is implemented and highly recommended for faster computations.
}
\examples{
data(simData)
Y <- simData$Y
init <- Eigen.HMM_init(Y = Y, k = 2, density = "MVT", mod.row = "EEE", mod.col = "EE", nstartR = 10)
}
