% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulation_mmc}
\alias{simulation_mmc}
\title{Maximized Monte Carlo Simulation}
\usage{
simulation_mmc(
  y,
  statistic,
  dgp = function(y, v) sample(y, replace = TRUE),
  v,
  N = 99,
  ...
)
}
\arguments{
\item{y}{A vector or data frame.}

\item{statistic}{A function or a character string that specifies
how the statistic is computed. The function needs to input the
\code{y} and output a scalar.}

\item{dgp}{A function. The function inputs the first argument
\code{y} and a vector of nuisance parameters \code{v} and outputs a simulated \code{y}.
It should represent the data generating process under the null.
Default value is the function \code{sample(y, replace = TRUE)}, i.e. the
bootstrap resampling of \code{y}.}

\item{v}{A vector parameters. The vector \code{v} is use to
specify the \code{dgp}. Note that if \code{dgp} is a
function  of only \code{y} then we do not need to specify
\code{v}. Default value is NULL.}

\item{N}{An atomic vector. Number of replications of the test
statistic.}

\item{...}{Other named arguments for statistic which are
passed unchanged each time it is called}
}
\value{
The vector of replication of test statistic.
}
\description{
Generates N Monte Carlo replicates of a statistic for given nuisance parameter value.
}
\keyword{internal}
