% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psyc_cons.R
\name{psyc_cons}
\alias{psyc_cons}
\title{psychrometric constant}
\usage{
psyc_cons(elev, P = NULL, control = list())
}
\arguments{
\item{elev}{elevation [m]}

\item{P}{atmospheric pressure [kPa]}

\item{control}{list for control parameters and empirical factors
defined in \code{\link{controlDefaults}} and \code{\link{constDefaults}} (see Details)}
}
\value{
psychrometric constant [kPa/degreeC]
}
\description{
The psychrometric constant [kPa/degreeC]
}
\details{
\describe{\item{control:}{
Tko: reference temperature [degreeC] at elevation z0. Only needed if atmospheric pressure is missing.
Often assumed to be 20 degreeC \cr\cr
elev: station elevation above sea level [m]. Needed if P = NULL for \code{\link{estP}}\cr\cr
lambda: latent heat of vaporization [MJ/kg] \cr\cr
eps: ratio molecular weight of water vapor/dry air = 0.622 \cr\cr
cp: specific heat of moist air = 1.013 x 10-3 [MJ/(kg degreeC)]}}
}
\note{
eq. 8 of reference
}
\examples{
psyc_cons(elev = 2, P = 101.3)
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998). Crop evapotranspiration-Guidelines for computing crop water requirements-FAO Irrigation and drainage paper 56. FAO, Rome, 300(9).
}
