% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{infert_df}
\alias{infert_df}
\title{Infertility after Spontaneous and Induced Abortion}
\format{
A data frame with 248 observations and 8 variables:
\describe{
  \item{education}{A factor representing the education level of the subjects, with 3 levels.}
  \item{age}{A numeric vector indicating the age of the subjects.}
  \item{parity}{A numeric vector representing the number of previous pregnancies.}
  \item{induced}{A numeric vector indicating the number of induced abortions.}
  \item{case}{A numeric vector indicating the case status (infertile or not).}
  \item{spontaneous}{A numeric vector indicating the number of spontaneous abortions.}
  \item{stratum}{An integer representing the stratum in the study.}
  \item{pooled.stratum}{A numeric vector representing the pooled stratum values.}
}
}
\source{
Data collected from clinical studies on infertility.
}
\usage{
data(infert_df)
}
\description{
The dataset name has been changed to 'infert_df' to avoid confusion with other datasets from
packages in the R ecosystem and to follow the naming conventions of the 'MedDataSets' package.
The suffix '_df' indicates that this dataset is a data frame, helping to distinguish it from other
datasets within the package and from those in the broader R ecosystem. The original content of the
dataset has not been modified in any way.
}
\details{
This dataset examines the relationship between various factors such as education level, age,
parity, and the incidence of infertility after spontaneous and induced abortion.
}
