% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{binding_df}
\alias{binding_df}
\title{Antibiotic Binding in Cows}
\format{
A data frame with 12 observations and 2 variables:
\describe{
  \item{antibiotic}{Factor variable indicating the type of antibiotic administered}
  \item{binding}{Numeric variable representing the measured binding rate to serum protein}
}
}
\source{
Data taken from the isdals package version 3.0.1
}
\usage{
data(binding_df)
}
\description{
This dataset, binding_df, is a data frame containing the binding rate of antibiotics to serum protein
in cows. The study measured the extent to which antibiotics bind to protein in the bloodstream, which
can reduce the medical effectiveness of the drug. Twelve cows were given one of three antibiotics:
chloramphenicol, erythromycin, or tetracycline.
}
\details{
The dataset name has been kept as 'binding_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
MedxR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
