% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fda_drugs_approved.R
\name{get_fda_drugs_approved}
\alias{get_fda_drugs_approved}
\title{Search FDA-Approved Drugs by Drug Name}
\source{
FDA Drugs at FDA Database via openFDA:
\url{https://open.fda.gov/apis/drug/drugsfda/}
}
\usage{
get_fda_drugs_approved(drug_name)
}
\arguments{
\item{drug_name}{A character string representing the name of the drug
(brand name or generic name).}
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{application_number}: FDA application number (NDA, ANDA, or BLA)
  \item \code{sponsor}: Name of the company that holds the application
  \item \code{brand}: Brand or trade name of the approved product
  \item \code{generic}: Generic (non-proprietary) name of the active ingredient
  \item \code{type}: Application type (NDA, ANDA, BLA)
  \item \code{approval_date}: Date the product was approved by FDA
  \item \code{strength}: Dosage strength of the product
  \item \code{form}: Pharmaceutical dosage form
  \item \code{route}: Route of administration
}
}
\description{
Retrieves information about FDA-approved drug products from the official
Drugs at FDA database that match a specific drug name using the RESTful API
endpoint \code{/drug/drugsfda.json?search=<drug_name>}.

This includes details such as the application number, sponsor name, approval dates,
product information, application type (NDA, ANDA, BLA), and submission details
for brand name drugs, generic drugs, and therapeutic biological products approved
by the FDA since 1939.
}
\details{
This function sends a GET request to the FDA openFDA API.
It supports caching via the \pkg{memoise} package to avoid redundant calls,
and respects a rate limit between successive API requests.

The Drugs at FDA database contains information about drug products approved
since 1939. The majority of labels, approval letters, and reviews are
available for products approved since 1998. This database includes brand
name drugs, generic drugs, and therapeutic biological products.

If the API request fails, returns no matches, or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires an internet connection.
}
\examples{
\donttest{
  # This function requires an internet connection and downloads data from FDA
  get_fda_drugs_approved("aspirin")
  get_fda_drugs_approved("lipitor")
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{as_tibble}}
}
