// Generated by rstantools.  Do not edit by hand.

/*
    MetaStan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    MetaStan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MetaStan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_SMA_Higgins_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_SMA_Higgins");
    reader.add_event(176, 174, "end", "model_SMA_Higgins");
    return reader;
}
#include <stan_meta_header.hpp>
class model_SMA_Higgins
  : public stan::model::model_base_crtp<model_SMA_Higgins> {
private:
        int Nobs;
        vector_d t;
        std::vector<int> st;
        int link;
        vector_d y;
        vector_d y_se;
        std::vector<int> r;
        std::vector<int> n;
        std::vector<int> count;
        vector_d exposure;
        vector_d mu_prior;
        vector_d theta_prior;
        double tau_prior;
        int tau_prior_dist;
        vector_d beta_prior;
        int re;
        int ncp;
        int mreg;
        int ncov;
        matrix_d cov;
public:
    model_SMA_Higgins(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_SMA_Higgins(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_SMA_Higgins_namespace::model_SMA_Higgins";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "Nobs", "int", context__.to_vec());
            Nobs = int(0);
            vals_i__ = context__.vals_i("Nobs");
            pos__ = 0;
            Nobs = vals_i__[pos__++];
            check_greater_or_equal(function__, "Nobs", Nobs, 1);
            current_statement_begin__ = 13;
            validate_non_negative_index("t", "Nobs", Nobs);
            context__.validate_dims("data initialization", "t", "vector_d", context__.to_vec(Nobs));
            t = Eigen::Matrix<double, Eigen::Dynamic, 1>(Nobs);
            vals_r__ = context__.vals_r("t");
            pos__ = 0;
            size_t t_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < t_j_1_max__; ++j_1__) {
                t(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 16;
            validate_non_negative_index("st", "Nobs", Nobs);
            context__.validate_dims("data initialization", "st", "int", context__.to_vec(Nobs));
            st = std::vector<int>(Nobs, int(0));
            vals_i__ = context__.vals_i("st");
            pos__ = 0;
            size_t st_k_0_max__ = Nobs;
            for (size_t k_0__ = 0; k_0__ < st_k_0_max__; ++k_0__) {
                st[k_0__] = vals_i__[pos__++];
            }
            size_t st_i_0_max__ = Nobs;
            for (size_t i_0__ = 0; i_0__ < st_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "st[i_0__]", st[i_0__], 1);
            }
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "link", "int", context__.to_vec());
            link = int(0);
            vals_i__ = context__.vals_i("link");
            pos__ = 0;
            link = vals_i__[pos__++];
            check_greater_or_equal(function__, "link", link, 1);
            check_less_or_equal(function__, "link", link, 3);
            current_statement_begin__ = 22;
            validate_non_negative_index("y", "Nobs", Nobs);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(Nobs));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(Nobs);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 23;
            validate_non_negative_index("y_se", "Nobs", Nobs);
            context__.validate_dims("data initialization", "y_se", "vector_d", context__.to_vec(Nobs));
            y_se = Eigen::Matrix<double, Eigen::Dynamic, 1>(Nobs);
            vals_r__ = context__.vals_r("y_se");
            pos__ = 0;
            size_t y_se_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < y_se_j_1_max__; ++j_1__) {
                y_se(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 26;
            validate_non_negative_index("r", "Nobs", Nobs);
            context__.validate_dims("data initialization", "r", "int", context__.to_vec(Nobs));
            r = std::vector<int>(Nobs, int(0));
            vals_i__ = context__.vals_i("r");
            pos__ = 0;
            size_t r_k_0_max__ = Nobs;
            for (size_t k_0__ = 0; k_0__ < r_k_0_max__; ++k_0__) {
                r[k_0__] = vals_i__[pos__++];
            }
            size_t r_i_0_max__ = Nobs;
            for (size_t i_0__ = 0; i_0__ < r_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "r[i_0__]", r[i_0__], 0);
            }
            current_statement_begin__ = 27;
            validate_non_negative_index("n", "Nobs", Nobs);
            context__.validate_dims("data initialization", "n", "int", context__.to_vec(Nobs));
            n = std::vector<int>(Nobs, int(0));
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            size_t n_k_0_max__ = Nobs;
            for (size_t k_0__ = 0; k_0__ < n_k_0_max__; ++k_0__) {
                n[k_0__] = vals_i__[pos__++];
            }
            size_t n_i_0_max__ = Nobs;
            for (size_t i_0__ = 0; i_0__ < n_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "n[i_0__]", n[i_0__], 1);
            }
            current_statement_begin__ = 31;
            validate_non_negative_index("count", "Nobs", Nobs);
            context__.validate_dims("data initialization", "count", "int", context__.to_vec(Nobs));
            count = std::vector<int>(Nobs, int(0));
            vals_i__ = context__.vals_i("count");
            pos__ = 0;
            size_t count_k_0_max__ = Nobs;
            for (size_t k_0__ = 0; k_0__ < count_k_0_max__; ++k_0__) {
                count[k_0__] = vals_i__[pos__++];
            }
            size_t count_i_0_max__ = Nobs;
            for (size_t i_0__ = 0; i_0__ < count_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "count[i_0__]", count[i_0__], 0);
            }
            current_statement_begin__ = 32;
            validate_non_negative_index("exposure", "Nobs", Nobs);
            context__.validate_dims("data initialization", "exposure", "vector_d", context__.to_vec(Nobs));
            exposure = Eigen::Matrix<double, Eigen::Dynamic, 1>(Nobs);
            vals_r__ = context__.vals_r("exposure");
            pos__ = 0;
            size_t exposure_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < exposure_j_1_max__; ++j_1__) {
                exposure(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 35;
            validate_non_negative_index("mu_prior", "2", 2);
            context__.validate_dims("data initialization", "mu_prior", "vector_d", context__.to_vec(2));
            mu_prior = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            vals_r__ = context__.vals_r("mu_prior");
            pos__ = 0;
            size_t mu_prior_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < mu_prior_j_1_max__; ++j_1__) {
                mu_prior(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 36;
            validate_non_negative_index("theta_prior", "2", 2);
            context__.validate_dims("data initialization", "theta_prior", "vector_d", context__.to_vec(2));
            theta_prior = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            vals_r__ = context__.vals_r("theta_prior");
            pos__ = 0;
            size_t theta_prior_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < theta_prior_j_1_max__; ++j_1__) {
                theta_prior(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 37;
            context__.validate_dims("data initialization", "tau_prior", "double", context__.to_vec());
            tau_prior = double(0);
            vals_r__ = context__.vals_r("tau_prior");
            pos__ = 0;
            tau_prior = vals_r__[pos__++];
            current_statement_begin__ = 38;
            context__.validate_dims("data initialization", "tau_prior_dist", "int", context__.to_vec());
            tau_prior_dist = int(0);
            vals_i__ = context__.vals_i("tau_prior_dist");
            pos__ = 0;
            tau_prior_dist = vals_i__[pos__++];
            current_statement_begin__ = 39;
            validate_non_negative_index("beta_prior", "2", 2);
            context__.validate_dims("data initialization", "beta_prior", "vector_d", context__.to_vec(2));
            beta_prior = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            vals_r__ = context__.vals_r("beta_prior");
            pos__ = 0;
            size_t beta_prior_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < beta_prior_j_1_max__; ++j_1__) {
                beta_prior(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 42;
            context__.validate_dims("data initialization", "re", "int", context__.to_vec());
            re = int(0);
            vals_i__ = context__.vals_i("re");
            pos__ = 0;
            re = vals_i__[pos__++];
            check_greater_or_equal(function__, "re", re, 0);
            check_less_or_equal(function__, "re", re, 1);
            current_statement_begin__ = 45;
            context__.validate_dims("data initialization", "ncp", "int", context__.to_vec());
            ncp = int(0);
            vals_i__ = context__.vals_i("ncp");
            pos__ = 0;
            ncp = vals_i__[pos__++];
            check_greater_or_equal(function__, "ncp", ncp, 0);
            check_less_or_equal(function__, "ncp", ncp, 1);
            current_statement_begin__ = 48;
            context__.validate_dims("data initialization", "mreg", "int", context__.to_vec());
            mreg = int(0);
            vals_i__ = context__.vals_i("mreg");
            pos__ = 0;
            mreg = vals_i__[pos__++];
            check_greater_or_equal(function__, "mreg", mreg, 0);
            check_less_or_equal(function__, "mreg", mreg, 1);
            current_statement_begin__ = 51;
            context__.validate_dims("data initialization", "ncov", "int", context__.to_vec());
            ncov = int(0);
            vals_i__ = context__.vals_i("ncov");
            pos__ = 0;
            ncov = vals_i__[pos__++];
            check_greater_or_equal(function__, "ncov", ncov, 0);
            current_statement_begin__ = 54;
            validate_non_negative_index("cov", "ncov", ncov);
            validate_non_negative_index("cov", "max(st)", max(st));
            context__.validate_dims("data initialization", "cov", "matrix_d", context__.to_vec(ncov,max(st)));
            cov = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(ncov, max(st));
            vals_r__ = context__.vals_r("cov");
            pos__ = 0;
            size_t cov_j_2_max__ = max(st);
            size_t cov_j_1_max__ = ncov;
            for (size_t j_2__ = 0; j_2__ < cov_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < cov_j_1_max__; ++j_1__) {
                    cov(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 59;
            validate_non_negative_index("mu", "Nobs", Nobs);
            num_params_r__ += Nobs;
            current_statement_begin__ = 60;
            num_params_r__ += 1;
            current_statement_begin__ = 61;
            validate_non_negative_index("u", "Nobs", Nobs);
            validate_non_negative_index("u", "re", re);
            num_params_r__ += (Nobs * re);
            current_statement_begin__ = 62;
            validate_non_negative_index("tau", "re", re);
            num_params_r__ += (1 * re);
            current_statement_begin__ = 63;
            validate_non_negative_index("beta", "ncov", ncov);
            validate_non_negative_index("beta", "mreg", mreg);
            num_params_r__ += (ncov * mreg);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_SMA_Higgins() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 59;
        if (!(context__.contains_r("mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        validate_non_negative_index("mu", "Nobs", Nobs);
        context__.validate_dims("parameter initialization", "mu", "vector_d", context__.to_vec(Nobs));
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu(Nobs);
        size_t mu_j_1_max__ = Nobs;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            mu(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(mu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 60;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "theta", "double", context__.to_vec());
        double theta(0);
        theta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(theta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 61;
        if (!(context__.contains_r("u")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable u missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("u");
        pos__ = 0U;
        validate_non_negative_index("u", "Nobs", Nobs);
        validate_non_negative_index("u", "re", re);
        context__.validate_dims("parameter initialization", "u", "vector_d", context__.to_vec(re,Nobs));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > u(re, Eigen::Matrix<double, Eigen::Dynamic, 1>(Nobs));
        size_t u_j_1_max__ = Nobs;
        size_t u_k_0_max__ = re;
        for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < u_k_0_max__; ++k_0__) {
                u[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t u_i_0_max__ = re;
        for (size_t i_0__ = 0; i_0__ < u_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(u[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable u: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 62;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        validate_non_negative_index("tau", "re", re);
        context__.validate_dims("parameter initialization", "tau", "double", context__.to_vec(re));
        std::vector<double> tau(re, double(0));
        size_t tau_k_0_max__ = re;
        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
            tau[k_0__] = vals_r__[pos__++];
        }
        size_t tau_i_0_max__ = re;
        for (size_t i_0__ = 0; i_0__ < tau_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, tau[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 63;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "ncov", ncov);
        validate_non_negative_index("beta", "mreg", mreg);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(mreg,ncov));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > beta(mreg, Eigen::Matrix<double, Eigen::Dynamic, 1>(ncov));
        size_t beta_j_1_max__ = ncov;
        size_t beta_k_0_max__ = mreg;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                beta[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t beta_i_0_max__ = mreg;
        for (size_t i_0__ = 0; i_0__ < beta_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(beta[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 59;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.vector_constrain(Nobs, lp__);
            else
                mu = in__.vector_constrain(Nobs);
            current_statement_begin__ = 60;
            local_scalar_t__ theta;
            (void) theta;  // dummy to suppress unused var warning
            if (jacobian__)
                theta = in__.scalar_constrain(lp__);
            else
                theta = in__.scalar_constrain();
            current_statement_begin__ = 61;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > u;
            size_t u_d_0_max__ = re;
            u.reserve(u_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < u_d_0_max__; ++d_0__) {
                if (jacobian__)
                    u.push_back(in__.vector_constrain(Nobs, lp__));
                else
                    u.push_back(in__.vector_constrain(Nobs));
            }
            current_statement_begin__ = 62;
            std::vector<local_scalar_t__> tau;
            size_t tau_d_0_max__ = re;
            tau.reserve(tau_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < tau_d_0_max__; ++d_0__) {
                if (jacobian__)
                    tau.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    tau.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 63;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > beta;
            size_t beta_d_0_max__ = mreg;
            beta.reserve(beta_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < beta_d_0_max__; ++d_0__) {
                if (jacobian__)
                    beta.push_back(in__.vector_constrain(ncov, lp__));
                else
                    beta.push_back(in__.vector_constrain(ncov));
            }
            // transformed parameters
            current_statement_begin__ = 67;
            validate_non_negative_index("d", "Nobs", Nobs);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> d(Nobs);
            stan::math::initialize(d, DUMMY_VAR__);
            stan::math::fill(d, DUMMY_VAR__);
            current_statement_begin__ = 68;
            validate_non_negative_index("temp", "max(st)", max(st));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> temp(max(st));
            stan::math::initialize(temp, DUMMY_VAR__);
            stan::math::fill(temp, DUMMY_VAR__);
            current_statement_begin__ = 69;
            validate_non_negative_index("beta_cov", "max(st)", max(st));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_cov(max(st));
            stan::math::initialize(beta_cov, DUMMY_VAR__);
            stan::math::fill(beta_cov, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 71;
            if (as_bool(mreg)) {
                current_statement_begin__ = 72;
                for (int i = 1; i <= Nobs; ++i) {
                    current_statement_begin__ = 73;
                    stan::model::assign(temp, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(st, i, "st", 1)), stan::model::nil_index_list()), 
                                (get_base1(get_base1(beta, 1, "beta", 1), 1, "beta", 2) * get_base1(cov, 1, get_base1(st, i, "st", 1), "cov", 1)), 
                                "assigning variable temp");
                }
                current_statement_begin__ = 75;
                if (as_bool(logical_eq(ncov, 1))) {
                    current_statement_begin__ = 76;
                    for (int i = 1; i <= Nobs; ++i) {
                        current_statement_begin__ = 77;
                        stan::model::assign(beta_cov, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(st, i, "st", 1)), stan::model::nil_index_list()), 
                                    get_base1(temp, get_base1(st, i, "st", 1), "temp", 1), 
                                    "assigning variable beta_cov");
                    }
                } else {
                    current_statement_begin__ = 81;
                    for (int j = 1; j <= ncov; ++j) {
                        current_statement_begin__ = 82;
                        for (int i = 1; i <= Nobs; ++i) {
                            current_statement_begin__ = 83;
                            stan::model::assign(beta_cov, 
                                        stan::model::cons_list(stan::model::index_uni(get_base1(st, i, "st", 1)), stan::model::nil_index_list()), 
                                        (get_base1(temp, get_base1(st, i, "st", 1), "temp", 1) + (get_base1(get_base1(beta, 1, "beta", 1), j, "beta", 2) * get_base1(cov, j, get_base1(st, i, "st", 1), "cov", 1))), 
                                        "assigning variable beta_cov");
                            current_statement_begin__ = 84;
                            stan::model::assign(temp, 
                                        stan::model::cons_list(stan::model::index_uni(get_base1(st, i, "st", 1)), stan::model::nil_index_list()), 
                                        get_base1(beta_cov, get_base1(st, i, "st", 1), "beta_cov", 1), 
                                        "assigning variable temp");
                        }
                    }
                }
            } else {
                current_statement_begin__ = 89;
                for (int i = 1; i <= Nobs; ++i) {
                    current_statement_begin__ = 90;
                    stan::model::assign(beta_cov, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(st, i, "st", 1)), stan::model::nil_index_list()), 
                                0, 
                                "assigning variable beta_cov");
                    current_statement_begin__ = 91;
                    stan::model::assign(temp, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(st, i, "st", 1)), stan::model::nil_index_list()), 
                                0, 
                                "assigning variable temp");
                }
            }
            current_statement_begin__ = 97;
            if (as_bool(re)) {
                current_statement_begin__ = 99;
                if (as_bool(ncp)) {
                    current_statement_begin__ = 100;
                    for (int i = 1; i <= Nobs; ++i) {
                        current_statement_begin__ = 101;
                        if (as_bool(logical_eq(get_base1(t, i, "t", 1), 0))) {
                            current_statement_begin__ = 102;
                            stan::model::assign(d, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        get_base1(mu, get_base1(st, i, "st", 1), "mu", 1), 
                                        "assigning variable d");
                        } else {
                            current_statement_begin__ = 104;
                            stan::model::assign(d, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (((get_base1(mu, get_base1(st, i, "st", 1), "mu", 1) + theta) + (get_base1(get_base1(u, 1, "u", 1), get_base1(st, i, "st", 1), "u", 2) * get_base1(tau, 1, "tau", 1))) + get_base1(beta_cov, get_base1(st, i, "st", 1), "beta_cov", 1)), 
                                        "assigning variable d");
                        }
                    }
                } else {
                    current_statement_begin__ = 109;
                    for (int i = 1; i <= Nobs; ++i) {
                        current_statement_begin__ = 110;
                        if (as_bool(logical_eq(get_base1(t, i, "t", 1), 0))) {
                            current_statement_begin__ = 111;
                            stan::model::assign(d, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        get_base1(mu, get_base1(st, i, "st", 1), "mu", 1), 
                                        "assigning variable d");
                        } else {
                            current_statement_begin__ = 113;
                            stan::model::assign(d, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        ((get_base1(mu, get_base1(st, i, "st", 1), "mu", 1) + get_base1(get_base1(u, 1, "u", 1), get_base1(st, i, "st", 1), "u", 2)) + get_base1(beta_cov, get_base1(st, i, "st", 1), "beta_cov", 1)), 
                                        "assigning variable d");
                        }
                    }
                }
            } else {
                current_statement_begin__ = 118;
                for (int i = 1; i <= Nobs; ++i) {
                    current_statement_begin__ = 119;
                    if (as_bool(logical_eq(get_base1(t, i, "t", 1), 0))) {
                        current_statement_begin__ = 120;
                        stan::model::assign(d, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    get_base1(mu, get_base1(st, i, "st", 1), "mu", 1), 
                                    "assigning variable d");
                    } else {
                        current_statement_begin__ = 122;
                        stan::model::assign(d, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((get_base1(mu, get_base1(st, i, "st", 1), "mu", 1) + theta) + get_base1(beta_cov, get_base1(st, i, "st", 1), "beta_cov", 1)), 
                                    "assigning variable d");
                    }
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 67;
            size_t d_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(d(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: d" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable d: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 68;
            size_t temp_j_1_max__ = max(st);
            for (size_t j_1__ = 0; j_1__ < temp_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(temp(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: temp" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable temp: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 69;
            size_t beta_cov_j_1_max__ = max(st);
            for (size_t j_1__ = 0; j_1__ < beta_cov_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(beta_cov(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_cov" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta_cov: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 131;
            if (as_bool(re)) {
                current_statement_begin__ = 132;
                if (as_bool(ncp)) {
                    current_statement_begin__ = 134;
                    lp_accum__.add(normal_log<propto__>(get_base1(u, 1, "u", 1), 0, 1));
                } else {
                    current_statement_begin__ = 137;
                    lp_accum__.add(normal_log<propto__>(get_base1(u, 1, "u", 1), d, get_base1(tau, 1, "tau", 1)));
                }
            }
            current_statement_begin__ = 141;
            lp_accum__.add(normal_log<propto__>(mu, get_base1(mu_prior, 1, "mu_prior", 1), get_base1(mu_prior, 2, "mu_prior", 1)));
            current_statement_begin__ = 142;
            lp_accum__.add(normal_log<propto__>(theta, get_base1(theta_prior, 1, "theta_prior", 1), get_base1(theta_prior, 2, "theta_prior", 1)));
            current_statement_begin__ = 144;
            if (as_bool(re)) {
                current_statement_begin__ = 146;
                if (as_bool(logical_eq(tau_prior_dist, 1))) {
                    current_statement_begin__ = 146;
                    lp_accum__.add(normal_log<propto__>(get_base1(tau, 1, "tau", 1), 0, tau_prior));
                    if (get_base1(tau, 1, "tau", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                    else lp_accum__.add(-normal_ccdf_log(0, 0, tau_prior));
                }
                current_statement_begin__ = 147;
                if (as_bool(logical_eq(tau_prior_dist, 2))) {
                    current_statement_begin__ = 147;
                    lp_accum__.add(uniform_log<propto__>(get_base1(tau, 1, "tau", 1), 0, tau_prior));
                }
                current_statement_begin__ = 148;
                if (as_bool(logical_eq(tau_prior_dist, 3))) {
                    current_statement_begin__ = 148;
                    lp_accum__.add(cauchy_log<propto__>(get_base1(tau, 1, "tau", 1), 0, tau_prior));
                    if (get_base1(tau, 1, "tau", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                    else lp_accum__.add(-cauchy_ccdf_log(0, 0, tau_prior));
                }
            }
            current_statement_begin__ = 151;
            if (as_bool(mreg)) {
                current_statement_begin__ = 151;
                lp_accum__.add(normal_log<propto__>(get_base1(beta, 1, "beta", 1), get_base1(beta_prior, 1, "beta_prior", 1), get_base1(beta_prior, 2, "beta_prior", 1)));
            }
            current_statement_begin__ = 154;
            if (as_bool(logical_eq(link, 1))) {
                current_statement_begin__ = 154;
                lp_accum__.add(normal_log<propto__>(y, d, y_se));
            }
            current_statement_begin__ = 155;
            if (as_bool(logical_eq(link, 2))) {
                current_statement_begin__ = 155;
                lp_accum__.add(binomial_logit_log<propto__>(r, n, d));
            }
            current_statement_begin__ = 156;
            if (as_bool(logical_eq(link, 3))) {
                current_statement_begin__ = 156;
                lp_accum__.add(poisson_log_log<propto__>(count, add(exposure, d)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu");
        names__.push_back("theta");
        names__.push_back("u");
        names__.push_back("tau");
        names__.push_back("beta");
        names__.push_back("d");
        names__.push_back("temp");
        names__.push_back("beta_cov");
        names__.push_back("log_lik");
        names__.push_back("theta_pred");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(Nobs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(re);
        dims__.push_back(Nobs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(re);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(mreg);
        dims__.push_back(ncov);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Nobs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(max(st));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(max(st));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Nobs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(re);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_SMA_Higgins_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu = in__.vector_constrain(Nobs);
        size_t mu_j_1_max__ = Nobs;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            vars__.push_back(mu(j_1__));
        }
        double theta = in__.scalar_constrain();
        vars__.push_back(theta);
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > u;
        size_t u_d_0_max__ = re;
        u.reserve(u_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < u_d_0_max__; ++d_0__) {
            u.push_back(in__.vector_constrain(Nobs));
        }
        size_t u_j_1_max__ = Nobs;
        size_t u_k_0_max__ = re;
        for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < u_k_0_max__; ++k_0__) {
                vars__.push_back(u[k_0__](j_1__));
            }
        }
        std::vector<double> tau;
        size_t tau_d_0_max__ = re;
        tau.reserve(tau_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < tau_d_0_max__; ++d_0__) {
            tau.push_back(in__.scalar_lb_constrain(0));
        }
        size_t tau_k_0_max__ = re;
        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > beta;
        size_t beta_d_0_max__ = mreg;
        beta.reserve(beta_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < beta_d_0_max__; ++d_0__) {
            beta.push_back(in__.vector_constrain(ncov));
        }
        size_t beta_j_1_max__ = ncov;
        size_t beta_k_0_max__ = mreg;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                vars__.push_back(beta[k_0__](j_1__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 67;
            validate_non_negative_index("d", "Nobs", Nobs);
            Eigen::Matrix<double, Eigen::Dynamic, 1> d(Nobs);
            stan::math::initialize(d, DUMMY_VAR__);
            stan::math::fill(d, DUMMY_VAR__);
            current_statement_begin__ = 68;
            validate_non_negative_index("temp", "max(st)", max(st));
            Eigen::Matrix<double, Eigen::Dynamic, 1> temp(max(st));
            stan::math::initialize(temp, DUMMY_VAR__);
            stan::math::fill(temp, DUMMY_VAR__);
            current_statement_begin__ = 69;
            validate_non_negative_index("beta_cov", "max(st)", max(st));
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta_cov(max(st));
            stan::math::initialize(beta_cov, DUMMY_VAR__);
            stan::math::fill(beta_cov, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 71;
            if (as_bool(mreg)) {
                current_statement_begin__ = 72;
                for (int i = 1; i <= Nobs; ++i) {
                    current_statement_begin__ = 73;
                    stan::model::assign(temp, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(st, i, "st", 1)), stan::model::nil_index_list()), 
                                (get_base1(get_base1(beta, 1, "beta", 1), 1, "beta", 2) * get_base1(cov, 1, get_base1(st, i, "st", 1), "cov", 1)), 
                                "assigning variable temp");
                }
                current_statement_begin__ = 75;
                if (as_bool(logical_eq(ncov, 1))) {
                    current_statement_begin__ = 76;
                    for (int i = 1; i <= Nobs; ++i) {
                        current_statement_begin__ = 77;
                        stan::model::assign(beta_cov, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(st, i, "st", 1)), stan::model::nil_index_list()), 
                                    get_base1(temp, get_base1(st, i, "st", 1), "temp", 1), 
                                    "assigning variable beta_cov");
                    }
                } else {
                    current_statement_begin__ = 81;
                    for (int j = 1; j <= ncov; ++j) {
                        current_statement_begin__ = 82;
                        for (int i = 1; i <= Nobs; ++i) {
                            current_statement_begin__ = 83;
                            stan::model::assign(beta_cov, 
                                        stan::model::cons_list(stan::model::index_uni(get_base1(st, i, "st", 1)), stan::model::nil_index_list()), 
                                        (get_base1(temp, get_base1(st, i, "st", 1), "temp", 1) + (get_base1(get_base1(beta, 1, "beta", 1), j, "beta", 2) * get_base1(cov, j, get_base1(st, i, "st", 1), "cov", 1))), 
                                        "assigning variable beta_cov");
                            current_statement_begin__ = 84;
                            stan::model::assign(temp, 
                                        stan::model::cons_list(stan::model::index_uni(get_base1(st, i, "st", 1)), stan::model::nil_index_list()), 
                                        get_base1(beta_cov, get_base1(st, i, "st", 1), "beta_cov", 1), 
                                        "assigning variable temp");
                        }
                    }
                }
            } else {
                current_statement_begin__ = 89;
                for (int i = 1; i <= Nobs; ++i) {
                    current_statement_begin__ = 90;
                    stan::model::assign(beta_cov, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(st, i, "st", 1)), stan::model::nil_index_list()), 
                                0, 
                                "assigning variable beta_cov");
                    current_statement_begin__ = 91;
                    stan::model::assign(temp, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(st, i, "st", 1)), stan::model::nil_index_list()), 
                                0, 
                                "assigning variable temp");
                }
            }
            current_statement_begin__ = 97;
            if (as_bool(re)) {
                current_statement_begin__ = 99;
                if (as_bool(ncp)) {
                    current_statement_begin__ = 100;
                    for (int i = 1; i <= Nobs; ++i) {
                        current_statement_begin__ = 101;
                        if (as_bool(logical_eq(get_base1(t, i, "t", 1), 0))) {
                            current_statement_begin__ = 102;
                            stan::model::assign(d, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        get_base1(mu, get_base1(st, i, "st", 1), "mu", 1), 
                                        "assigning variable d");
                        } else {
                            current_statement_begin__ = 104;
                            stan::model::assign(d, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (((get_base1(mu, get_base1(st, i, "st", 1), "mu", 1) + theta) + (get_base1(get_base1(u, 1, "u", 1), get_base1(st, i, "st", 1), "u", 2) * get_base1(tau, 1, "tau", 1))) + get_base1(beta_cov, get_base1(st, i, "st", 1), "beta_cov", 1)), 
                                        "assigning variable d");
                        }
                    }
                } else {
                    current_statement_begin__ = 109;
                    for (int i = 1; i <= Nobs; ++i) {
                        current_statement_begin__ = 110;
                        if (as_bool(logical_eq(get_base1(t, i, "t", 1), 0))) {
                            current_statement_begin__ = 111;
                            stan::model::assign(d, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        get_base1(mu, get_base1(st, i, "st", 1), "mu", 1), 
                                        "assigning variable d");
                        } else {
                            current_statement_begin__ = 113;
                            stan::model::assign(d, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        ((get_base1(mu, get_base1(st, i, "st", 1), "mu", 1) + get_base1(get_base1(u, 1, "u", 1), get_base1(st, i, "st", 1), "u", 2)) + get_base1(beta_cov, get_base1(st, i, "st", 1), "beta_cov", 1)), 
                                        "assigning variable d");
                        }
                    }
                }
            } else {
                current_statement_begin__ = 118;
                for (int i = 1; i <= Nobs; ++i) {
                    current_statement_begin__ = 119;
                    if (as_bool(logical_eq(get_base1(t, i, "t", 1), 0))) {
                        current_statement_begin__ = 120;
                        stan::model::assign(d, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    get_base1(mu, get_base1(st, i, "st", 1), "mu", 1), 
                                    "assigning variable d");
                    } else {
                        current_statement_begin__ = 122;
                        stan::model::assign(d, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((get_base1(mu, get_base1(st, i, "st", 1), "mu", 1) + theta) + get_base1(beta_cov, get_base1(st, i, "st", 1), "beta_cov", 1)), 
                                    "assigning variable d");
                    }
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t d_j_1_max__ = Nobs;
                for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
                    vars__.push_back(d(j_1__));
                }
                size_t temp_j_1_max__ = max(st);
                for (size_t j_1__ = 0; j_1__ < temp_j_1_max__; ++j_1__) {
                    vars__.push_back(temp(j_1__));
                }
                size_t beta_cov_j_1_max__ = max(st);
                for (size_t j_1__ = 0; j_1__ < beta_cov_j_1_max__; ++j_1__) {
                    vars__.push_back(beta_cov(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 161;
            validate_non_negative_index("log_lik", "Nobs", Nobs);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(Nobs);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 162;
            validate_non_negative_index("theta_pred", "re", re);
            std::vector<double> theta_pred(re, double(0));
            stan::math::initialize(theta_pred, DUMMY_VAR__);
            stan::math::fill(theta_pred, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 165;
            for (int s = 1; s <= Nobs; ++s) {
                current_statement_begin__ = 166;
                if (as_bool(logical_eq(link, 1))) {
                    current_statement_begin__ = 166;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                normal_log(get_base1(y, s, "y", 1), get_base1(d, s, "d", 1), get_base1(y_se, s, "y_se", 1)), 
                                "assigning variable log_lik");
                }
                current_statement_begin__ = 167;
                if (as_bool(logical_eq(link, 2))) {
                    current_statement_begin__ = 167;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                binomial_logit_log(get_base1(r, s, "r", 1), get_base1(n, s, "n", 1), get_base1(d, s, "d", 1)), 
                                "assigning variable log_lik");
                }
                current_statement_begin__ = 168;
                if (as_bool(logical_eq(link, 3))) {
                    current_statement_begin__ = 168;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                poisson_log_log(get_base1(count, s, "count", 1), (get_base1(exposure, s, "exposure", 1) + get_base1(d, s, "d", 1))), 
                                "assigning variable log_lik");
                }
            }
            current_statement_begin__ = 172;
            if (as_bool(re)) {
                current_statement_begin__ = 172;
                stan::model::assign(theta_pred, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            normal_rng(theta, get_base1(tau, 1, "tau", 1), base_rng__), 
                            "assigning variable theta_pred");
            }
            // validate, write generated quantities
            current_statement_begin__ = 161;
            size_t log_lik_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
            current_statement_begin__ = 162;
            size_t theta_pred_k_0_max__ = re;
            for (size_t k_0__ = 0; k_0__ < theta_pred_k_0_max__; ++k_0__) {
                vars__.push_back(theta_pred[k_0__]);
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_SMA_Higgins";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t mu_j_1_max__ = Nobs;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta";
        param_names__.push_back(param_name_stream__.str());
        size_t u_j_1_max__ = Nobs;
        size_t u_k_0_max__ = re;
        for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < u_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "u" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t tau_k_0_max__ = re;
        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = ncov;
        size_t beta_k_0_max__ = mreg;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t d_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "d" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t temp_j_1_max__ = max(st);
            for (size_t j_1__ = 0; j_1__ < temp_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "temp" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_cov_j_1_max__ = max(st);
            for (size_t j_1__ = 0; j_1__ < beta_cov_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_cov" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = Nobs;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_pred_k_0_max__ = re;
        for (size_t k_0__ = 0; k_0__ < theta_pred_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_pred" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t mu_j_1_max__ = Nobs;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta";
        param_names__.push_back(param_name_stream__.str());
        size_t u_j_1_max__ = Nobs;
        size_t u_k_0_max__ = re;
        for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < u_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "u" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t tau_k_0_max__ = re;
        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = ncov;
        size_t beta_k_0_max__ = mreg;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t d_j_1_max__ = Nobs;
            for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "d" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t temp_j_1_max__ = max(st);
            for (size_t j_1__ = 0; j_1__ < temp_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "temp" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_cov_j_1_max__ = max(st);
            for (size_t j_1__ = 0; j_1__ < beta_cov_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_cov" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = Nobs;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_pred_k_0_max__ = re;
        for (size_t k_0__ = 0; k_0__ < theta_pred_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_pred" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_SMA_Higgins_namespace::model_SMA_Higgins stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
