% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiRegion_SIM.R
\name{cftpStepGenerator}
\alias{cftpStepGenerator}
\title{cftpStepGenerator}
\description{
an R6 class representing the steps for sampling a sequence of methylation states
from the equilibrium (SSEi and SSEc considered, IWE neglected)
using the CFTP algorithm for a given combiStructureGenerator instance.

It is stored in the private attribute CFTP_info of combiStructureGenerator instances
when calling the combiStructureGenerator$cftp() method
and can be retrieved with the combiStructureGenerator$get_CFTP_info()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{singleStr_number}}{Public attribute: Number of singleStr instances}

\item{\code{singleStr_siteNumber}}{Public attribute: Number of sites in singleStr instances}

\item{\code{CFTP_highest_rate}}{Public attribute: CFTP highest rate}

\item{\code{number_steps}}{Public attribute: counter of steps alredy generated}

\item{\code{CFTP_chosen_singleStr}}{Public attribute: list with vectors of equal size with chosen singleStr index at each CFTP step}

\item{\code{CFTP_chosen_site}}{Public attribute: list with vectors of equal size with chosen site index at each CFTP step}

\item{\code{CFTP_event}}{Public attribute: list with vectors of equal size with type of CFTP event at each CFTP step.}

\item{\code{CFTP_random}}{Public attribute: list with vectors of equal size with CFTP threshold at each CFTP step}

\item{\code{steps_perVector}}{Public attribute: size of vectors in lists CFTP_chosen_singleStr, CFTP_chosen_site, CFTP_event and CFTP_random}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-cftpStepGenerator-new}{\code{cftpStepGenerator$new()}}
\item \href{#method-cftpStepGenerator-generate_events}{\code{cftpStepGenerator$generate_events()}}
\item \href{#method-cftpStepGenerator-clone}{\code{cftpStepGenerator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cftpStepGenerator-new"></a>}}
\if{latex}{\out{\hypertarget{method-cftpStepGenerator-new}{}}}
\subsection{Method \code{new()}}{
Create a new instance of class cftpStepGenerator with the info of the corresponding combiStrucutre instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cftpStepGenerator$new(
  singleStr_number,
  singleStr_siteNumber,
  CFTP_highest_rate
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{singleStr_number}}{Number of singleStr instances}

\item{\code{singleStr_siteNumber}}{Number of sites in singleStr instances}

\item{\code{CFTP_highest_rate}}{CFTP highest rate across all singleStr withing combiStr instance}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new instance of class cftpStepGenerator
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cftpStepGenerator-generate_events"></a>}}
\if{latex}{\out{\hypertarget{method-cftpStepGenerator-generate_events}{}}}
\subsection{Method \code{generate_events()}}{
1: SSEi to unmethylated, 2: SSEi to partially methylated, 3: SSEi to methylated
4: SSEc copy left state, 5: SSEc copy right state


Public Method. Generates the events to apply for CFTP.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cftpStepGenerator$generate_events(steps = 10000, testing = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{steps}}{Integer value >=1}

\item{\code{testing}}{default FALSE. TRUE for testing output}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The function add steps to the existing ones.
If called several times the given steps need to be higher than the sum of steps generated before.
}

\subsection{Returns}{
NULL when testing FALSE. Testing output when testing TRUE.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cftpStepGenerator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-cftpStepGenerator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cftpStepGenerator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
