% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStatistics.R
\name{validate_data_cherryDist}
\alias{validate_data_cherryDist}
\title{Validate Structure of Input Data for Cherry Distance Computation}
\usage{
validate_data_cherryDist(cherryDist, data)
}
\arguments{
\item{cherryDist}{A data frame containing cherry pair distances, including tip indices (output from \code{get_cherryDist})}

\item{data}{A nested list representing structured data for each tip, following the format \code{data[[tip]][[structure]]}.}
}
\description{
This function checks whether the provided input data has the required structure.
It ensures that the number of tips is sufficient and that the data structure is consistent across tips and structures.
}
\details{
The function performs several validation steps:
\itemize{
\item Ensures that the number of tips in \code{data} is at least as large as the highest tip index in \code{cherryDist}.
\item Checks that all tips contain at least one structure and that the number of structures is consistent across tips.
\item Verifies that within each structure, all tips have the same number of sites and no zero-length structures.
}

If any of these conditions fail, the function throws an error with a descriptive message.
}
