% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_classification.R
\name{recall}
\alias{recall}
\title{Recall}
\usage{
recall(actual, predicted)
}
\arguments{
\item{actual}{The ground truth binary numeric vector containing 1 for the positive
class and 0 for the negative class.}

\item{predicted}{The predicted binary numeric vector containing 1 for the positive
class and 0 for the negative class. Each element represents the
prediction for the corresponding element in \code{actual}.}
}
\description{
\code{recall} computes proportion of observations in the positive class
              (i.e. the element in \code{actual} equals 1) that are predicted
              to be in the positive class (i.e. the element in \code{predicted}
              equals 1)
}
\examples{
actual <- c(1, 1, 1, 0, 0, 0)
predicted <- c(1, 0, 1, 1, 1, 1)
recall(actual, predicted)
}
\seealso{
\code{\link{precision}} \code{\link{fbeta_score}}
}
