% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.codes.R
\name{Data.opp.cor.vis}
\alias{Data.opp.cor.vis}
\title{Visualize Opposing Temporal profiles among Microbial features.}
\usage{
Data.opp.cor.vis(
  predicted_data,
  pre_processed_data,
  Design_data,
  ng_cor_thres,
  Taxa = NULL,
  plot_dots = TRUE,
  figure_x_scale = 5,
  title_size = 10,
  axis_title_size = 10,
  axis_text_y_size = 8,
  axis_text_x_size = 8,
  legend_title_size = 10,
  legend_text_size = 8,
  dots_size = 0.6
)
}
\arguments{
\item{predicted_data}{The output data frame from the \code{\link[MicrobTiSDA]{Pred.data}}).}

\item{pre_processed_data}{The transformed data output from the \code{\link[MicrobTiSDA]{Data.trans}} function. A
pre-processed OTU data frame with sample IDs as row names and OTU IDs as column names.}

\item{Design_data}{The output data from the \code{\link[MicrobTiSDA]{Design}}).}

\item{ng_cor_thres}{A numeric value specifying the correlation threshold below which OTUs are considered to exhibit opposing trends.}

\item{Taxa}{A data frame providing taxonomic annotations for microbial species.}

\item{plot_dots}{Logical; if \code{TRUE}, raw data points are overlaid on the temporal curves (default: \code{TRUE}).}

\item{figure_x_scale}{A numeric value specifying the interval for x-axis breaks in the figures (default: \code{5}).}

\item{title_size}{A numeric value specifying the font size for the plot title (default: \code{10}).}

\item{axis_title_size}{A numeric value specifying the font size for the axis titles (default: \code{8}).}

\item{axis_text_y_size}{A numeric value specifying the font size for the y-axis text (default: \code{5}).}

\item{axis_text_x_size}{A numeric value specifying the font size for the x-axis text (default: \code{5}).}

\item{legend_title_size}{A numeric value specifying the font size for legend titles (default: \code{5}).}

\item{legend_text_size}{A numeric value specifying the font size for legend text (default: \code{5}).}

\item{dots_size}{A numeric value specifying the size of the overlaid raw data points (default: \code{0.7}).}
}
\value{
An object of class \code{DataOppCorVis} which contains the list of each targeted microbial feature.
}
\description{
This function identifies and visualizes OTUs/ASVs that exhibit opposing temporal trends based on a correlation threshold.
It computes the correlation matrix of predicted OTU/ASV time-series data, selects those OTUs with correlations below a specified threshold,
and generates smoothed temporal profile plots. Optionally, raw data points are overlaid and taxonomic annotations are added if provided.
}
\details{
For each group in the \code{predicted_data} list, the function first removes the time column and computes a correlation matrix
from the predicted OTU data. It then extracts, for each OTU, the subset of OTUs that show a correlation lower than the specified threshold
(\eqn{\text{ng\_cor\_thres}}). If an OTU does not have any opposing trends (i.e., all correlations exceed the threshold), it is skipped.
For those OTUs meeting the criteria, the function restructures the data into long format and plots the temporal profiles using
\code{geom_smooth} to display the primary trend (solid line) and opposing trends (dashed lines). If \code{plot_dots} is \code{TRUE},
the raw data points extracted from the design data are also overlaid. When taxonomic annotations are provided via \code{Taxa},
OTU labels are augmented with species information. The x-axis is scaled according to \code{figure_x_scale}, and plot aesthetics
(titles, axis text, legends, and dot sizes) can be customized using the respective parameters.
}
\author{
Shijia Li
}
