% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.codes.R
\name{Data.trans}
\alias{Data.trans}
\title{Transform Microbial Composition Data.}
\usage{
Data.trans(Data, metadata, Group_var)
}
\arguments{
\item{Data}{A data frame or matrix of microbial compositional data, with rows representing microbial features (OTUs/ASVs)
and columns representing samples. If the function \code{Data.interpolate} is preformed, the first element of the output
object of \code{Data.interpolate} should be extract as the input of this function.}

\item{metadata}{A data frame. Containing information about all samples, including at least the grouping of all samples as well as
individual information (\code{Group} and \code{ID}), the sampling \code{Time} point for each sample, and other relevant information.}

\item{Group_var}{A string or a vector. This specifies the grouping variables, which should match the column names in
the \code{metadata} used to designate sample groups, and for pre-processing OTU data of each group or individual separately.
For instance, to split the OTU table based on the \code{"Group"} variable, set \code{Group_var = "Group"};
to split the data based on the \code{"Group"} and \code{"Diet"} (if in \code{metadata})categorical variables to study the
interaction between different grouping variables, set \code{Group_var = c("Group","Diet")}.}
}
\value{
An object of class \code{"TransformedData"} containing the transformed count table.
}
\description{
This function applies the modified centered log-ratio (MCLR) transformation function \code{\link[MicrobTiSDA]{mclr.transform}}
to a data matrix (e.g., OTU/ASV counts). When a grouping variable is provided the transformation is applied separately for
each group defined in the metadata.
}
\details{
The function transforms the input data using the MCLR method. If no grouping variable is provided (i.e. \code{Group_var}
is \code{NULL}), the transformation is applied to the entire dataset. If a single grouping variable is specified,
the data is partitioned into subsets corresponding to the unique groups in the metadata, and the transformation
is applied to each subset separately; the results are then combined using row binding. For multiple grouping variables,
a composite grouping factor is created using the interaction of the specified variables, and the transformation is
applied to each composite group in a similar manner.
}
\examples{
\donttest{
# Create example data matrix (5 features x 10 samples)
set.seed(123)
Data <- matrix(sample(1:100, 50, replace = TRUE), nrow = 5)
rownames(Data) <- paste0("Feature", 1:5)
colnames(Data) <- paste0("Sample", 1:10)

# Create example metadata with a grouping variable
metadata <- data.frame(Group = rep(c("A", "B"), each = 5))
rownames(metadata) <- paste0("Sample", 1:10)

# Apply MCLR transformation to the entire dataset
transformed_data <- Data.trans(Data, metadata, Group_var = NULL)

# Apply MCLR transformation separately for each group
transformed_data_by_group <- Data.trans(Data, metadata, Group_var = "Group")
}

}
\author{
Shijia Li
}
