% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.codes.R
\name{Rf.biomarkers}
\alias{Rf.biomarkers}
\title{Select Biomarkers Based on Random Forest Cross-Validation Results}
\usage{
Rf.biomarkers(rf = rf_results, feature_select_num)
}
\arguments{
\item{rf}{A list containing the results of the random forest classification. Default to \code{\link[MicrobTiSDA]{Data.rf.classifier}}.}

\item{feature_select_num}{A numeric value specifying the number of top features (biomarkers) to select. Typically, the numer of
specified biomarkers needs to be determined by the user based on the cross-validation result plot output by
\code{\link[MicrobTiSDA]{Data.rf.classifier}}.}
}
\value{
An object of class \code{RfBiomarker} with two elements:
\describe{
\item{OTU_importance}{A data frame of the selected biomarkers (transposed feature table).}
\item{cross_validation_fig}{A ggplot object of the cross-validation plot with a vertical dashed line indicating the feature selection cutoff.}
}
}
\description{
This function extracts the top biomarkers from a random forest classification result based on cross-validation
and user specified number of microbial features. It updates the cross-validation plot by adding a vertical
dashed line at the specified number of features, and then selects the top features (biomarkers) based on
their importance ranking.
}
\details{
The function takes an object (usually the output from \code{\link[MicrobTiSDA]{Data.rf.classifier}}, which includes
a cross-validation plot, an OTU importance table, and the original input data) and a user-specified
number of features to select. It then updates the cross-validation plot by adding a vertical dashed line
at the position corresponding to the number of selected features. Next, it extracts the top features from the
OTU importance table (ordered by Mean Decrease Accuracy) and creates q table of these features
from the original microbial feature table. The function returns a list that includes both the transposed biomarker
table and the modified cross-validation plot.
}
\examples{
\donttest{
# Example OTU count data (20 OTUs x 10 samples)
set.seed(123)
otu_data <- matrix(sample(0:100, 200, replace = TRUE), nrow = 20)
colnames(otu_data) <- paste0("Sample", 1:10)
rownames(otu_data) <- paste0("OTU", 1:20)

# Example metadata with group labels
metadata <- data.frame(Group = rep(c("Control", "Treatment"), each = 5))

# Run the classifier
rf_result <- Data.rf.classifier(raw_data = otu_data,
                             metadata = metadata,
                             train_p = 0.7,
                             Group = "Group",
                             OTU_counts_filter_value = 50)
# If you wish to select the top 5 features:
result <- Rf.biomarkers(rf = rf_result, feature_select_num = 5)
# View the biomarker table
print(result$OTU_importance)
# View the updated cross-validation plot
print(result$cross_validation_fig)
}
}
\author{
Shijia Li
}
