% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{MicrobialGrowth.create}
\alias{MicrobialGrowth.create}
\title{MicrobialGrowth create function}
\usage{
MicrobialGrowth.create(
  N0,
  Nmax,
  mu,
  lambda,
  xlim,
  model = "gompertz",
  n = 101,
  ...
)
}
\arguments{
\item{N0}{initial population.}

\item{Nmax}{final/maximum population.}

\item{mu}{growth rate.}

\item{lambda}{latency time.}

\item{xlim}{range of values to simulate \code{x} and \code{y} (and hence plotting, \emph{etc.})}

\item{model}{wanted growth model: "baranyi", "gompertz" or "rosso"}

\item{n}{number of points to simulate in the interval \code{xlim}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a MicrobialGrowth-object composed of
\item{call}{the matched call with several components.}
\item{coefficients}{coefficients obtained by regression.}
\item{data}{data used for regression, once the y values are clipped}
\item{f}{a list of functions such as \code{formula} to retrieve the function of the model with the coefficients obtained by regression, \code{confint} to retrieve the confidence intervals, etc.}
\item{isValid}{a boolean indicating whether the regression was successful or not.}
\item{message}{always with this method.}
\item{reg}{always with this method.}
}
\description{
MicrobialGrowth-object creator from the 4 biological meaning parameters.
}
\details{
The \code{N0}, \code{Nmax}, \code{mu} and \code{lambda} parameter-coefficients can be given as one to three values.

A single value means that the coefficient and the confidence interval values will be identical.

Two values means that they will correspond to the confidence interval, and the coefficient will be calculated as the average of these two values.

Three values means that each of these values will be associated with the coefficient or the confidence interval.

Values are always sorted automatically, which means that \code{c(2,1,3)} is equivalent to \code{c(1,2,3)}.
}
\examples{
# Simple example
g <- MicrobialGrowth.create(N0 = 0.14, Nmax = 1.43, mu = 0.07, lambda = 45,
     xlim = c(0, 100), model="gompertz")

# Example from a regression (whose values can be stored and then reused later)
g <- MicrobialGrowth(example_data$time, example_data$y1, model="gompertz")
c <- g$coefficients
g2 <- MicrobialGrowth.create(c$N0, c$Nmax, c$mu, c$lambda,
      xlim = c(min(g$data$x),max(g$data$x)), n = length(g$data$x), model="gompertz")

# Example with confidence intervals
g <- MicrobialGrowth.create(N0 = c(0.13, 0.15), Nmax = 1.43, mu = c(0.05, 0.07, 0.09),
lambda = c(45, 49, 43), xlim = c(0, 100), model="gompertz")
# Coefficient N0 is 0.14 and the confidence interval is (0.13, 0.15)
# Coefficient Nmax is 1.43 and the confidence interval is (1.43, 1.43)
# Coefficient mu is 0.07 and the confidence interval is (0.05, 0.09)
# Coefficient lambda is 45 and the confidence interval is (43, 49)
}
