% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\name{is.gompertz}
\alias{is.gompertz}
\title{Gompertz class}
\usage{
is.gompertz(x)
}
\arguments{
\item{x}{variable or list.}
}
\value{
\code{TRUE} if the object or all objects are of class \code{gompertz}.
}
\description{
Test if a variable or variable list is/are gompertz-object(s).
}
\examples{
# TRUE return
g1 <- MicrobialGrowth(example_data$time, example_data$y1)
g2 <- MicrobialGrowth.create(N0 = 0.14, Nmax = 1.43, mu = 0.07, lambda = 45,
                                   xlim = c(0, 100), model="gompertz")
is.gompertz(g1)
is.gompertz(g2)
is.gompertz(c(g1, g2))
is.gompertz(list(g1,g2))

# FALSE return
is.gompertz(1)
is.gompertz(list())
is.gompertz(c(g1, g2, 1))
is.gompertz(list(g1, g2, 1))
}
