% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linda.R
\name{linda.wald.test}
\alias{linda.wald.test}
\title{Wald test for bias-corrected regression coefficients}
\usage{
linda.wald.test(
  linda.obj,
  L,
  model = c("LM", "LMM"),
  alpha = 0.05,
  p.adj.method = "BH"
)
}
\arguments{
\item{linda.obj}{return from the \code{linda} function.}

\item{L}{A matrix for testing \code{Lb = 0}, where \code{b} includes the intercept and all fixed effects from runing \code{linda}. Thus the number of columns of L must be equal to \code{length(variables)+1}, where \code{variables} is from \code{linda.obj}, which does not include the intercept.}

\item{model}{\code{'LM'} or \code{'LMM'} indicating the model fitted in \{linda\} is linear model or linear mixed-effect model.}

\item{alpha}{significance level for testing \code{Lb = 0}.}

\item{p.adj.method}{P-value adjustment approach. See R function \code{p.adjust}. The default is 'BH'.}
}
\value{
A data frame with columns
\item{Fstat}{Wald statistics for each taxon}
\item{df1}{The numerator degrees of freedom}
\item{df2}{The denominator degrees of freedom}
\item{pvalue}{ \code{1 - pf(Fstat, df1, df2)}}
\item{padj}{ \code{p.adjust(pvalue, method = p.adj.method)}}
\item{reject}{ \code{padj <= alpha}}
}
\description{
The function implements Wald test for bias-corrected regression coefficients generated from the \code{linda} function.
One can utilize the function to perform ANOVA-type analyses. For example, if you have a cateogrical variable with three levels, you can test whether all levels have the same effect.
}
\examples{

\donttest{
data(smokers)

ind <- smokers$meta$AIRWAYSITE == 'Throat'
otu.tab <- as.data.frame(smokers$otu[, ind])
depth <- colSums(otu.tab)
meta <- cbind.data.frame(Smoke = factor(smokers$meta$SMOKER[ind]),
                         Sex = factor(smokers$meta$SEX[ind]),
                         Site = factor(smokers$meta$SIDEOFBODY[ind]),
                         SubjectID = factor(smokers$meta$HOST_SUBJECT_ID[ind]))
ind  <- depth >= 1000
linda.obj <- linda(otu.tab[, ind], meta[ind, ], formula = '~Smoke+Sex+(1|SubjectID)',
           feature.dat.type = 'count', 
           prev.filter = 0.1, is.winsor = TRUE, outlier.pct = 0.03,
           p.adj.method = "BH", alpha = 0.1)
#  L matrix (2x3) is designed to test the second (Smoke) and the third (Sex) coefficient to be 0.
# For a categorical variable > two levels, similar L can be designed to do ANOVA-type test. 
L <- matrix(c(0, 1, 0, 0, 0, 1), nrow = 2, byrow = TRUE)
result <- linda.wald.test(linda.obj, L, 'LMM', alpha = 0.1)
}

}
\references{
Zhou, H., He, K., Chen, J., Zhang, X. (2022). LinDA: linear models for differential abundance analysis of microbiome compositional data. Genome biology, 23(1), 95.
}
\author{
Huijuan Zhou \email{huijuanzhou2019@gmail.com}
Jun Chen \email{Chen.Jun2@mayo.edu}
Xianyang Zhang \email{zhangxiany@stat.tamu.edu}
}
