% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Majorityvotes.R
\name{Majorityvotes}
\alias{Majorityvotes}
\title{Classifiction for Majority Votes}
\usage{
Majorityvotes(Result, Prognostic, Survival, Censor, J = 1)
}
\arguments{
\item{Result}{An object obtained from the taxon specific analysis (\code{\link[MicrobiomeSurv]{MSpecificCoxPh}}) which is of class "ms"}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Survival}{A vector of survival time with length equals to number of subjects}

\item{Censor}{A vector of censoring indicator}

\item{J}{The jth set of subjects required for the visualization. The default is J=1 which is the first set of subjects. For visualization, J should be less than the number of subjects divided by 25}
}
\value{
A list is returned with the following values
  \item{Model.result}{The cox proportional regression result based on the majority vote classification}
  \item{N}{The majority vote for each subject}
  \item{Classif}{The majority vote classification for each subjects}
  \item{Group}{The classification of the subjects based on each taxon analysis}
}
\description{
The Function fits cox proportional hazard model and does classification based on the majority votes.
}
\details{
The Function fits cox proportional hazard model and does classification based on the majority votes
while estimating the Hazard ratio of the low risk group.
The function firstly count the number of low risk classification for each subject based on the taxon specific analysis
which determines the majority votes.
In addition, function visualizes the taxon specific calssification for the subjects. 25 subjects is taken for visualization purpose.
}
\examples{
# Prepare data
data(Week3_response)
Week3_response = data.frame(Week3_response)
surv_fam_shan_w3 = data.frame(cbind(as.numeric(Week3_response$T1Dweek),
as.numeric(Week3_response$T1D)))
colnames(surv_fam_shan_w3) = c("Survival", "Censor")
prog_fam_shan_w3 = data.frame(factor(Week3_response$Treatment_new))
colnames(prog_fam_shan_w3) = c("Treatment")
data(fam_shan_trim_w3)
names_fam_shan_trim_w3 =
c("Unknown", "Lachnospiraceae", "S24.7", "Lactobacillaceae", "Enterobacteriaceae", "Rikenellaceae")
fam_shan_trim_w3 = data.matrix(fam_shan_trim_w3[ ,2:82])
rownames(fam_shan_trim_w3) = names_fam_shan_trim_w3
# Running the taxon specific function
Cox_taxon_fam_shan_w3 = MSpecificCoxPh(Survival = surv_fam_shan_w3$Survival,
                                       Micro.mat = fam_shan_trim_w3,
                                       Censor = surv_fam_shan_w3$Censor,
                                       Reduce=FALSE,
                                       Select=5,
                                       Prognostic = prog_fam_shan_w3,
                                       Mean = TRUE,
                                       Method = "BH")

# Using the function
Majority_fam_shan_w3 = Majorityvotes(Result = Cox_taxon_fam_shan_w3,
                                     Prognostic = prog_fam_shan_w3,
                                     Survival = surv_fam_shan_w3$Survival,
                                     Censor = surv_fam_shan_w3$Censor,
                                     J=1)

# The survival analysis for majority vote result
Majority_fam_shan_w3$Model.result

# The majority vote for each subject
Majority_fam_shan_w3$N

# The majority vote classification for each subject
Majority_fam_shan_w3$Classif

# The group for each subject based on the taxon specific analysis
Majority_fam_shan_w3$Group
}
\seealso{
\code{\link[MicrobiomeSurv]{MSpecificCoxPh}}, \code{\link[survival]{coxph}},  \code{\link[MicrobiomeSurv]{EstimateHR}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
