% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvpp-class.R
\docType{class}
\name{cvpp-class}
\alias{cvpp-class}
\alias{cvpp}
\alias{show,cvpp-method}
\alias{summary,cvpp-method}
\alias{plot,cvpp,missing-method}
\alias{cvpp-method}
\title{The cvpp Class.}
\usage{
\S4method{show}{cvpp}(object)

\S4method{summary}{cvpp}(object)

\S4method{plot}{cvpp,missing}(x, y, ...)
}
\arguments{
\item{object}{A cvpp class object}

\item{x}{A cvpp class object}

\item{y}{missing}

\item{...}{The usual extra arguments to generic functions — see \code{\link[graphics]{plot}}, \code{\link[graphics]{plot.default}}}
}
\description{
Class of object returned by function \code{\link[MicrobiomeSurv]{CVPcaPls}}.
}
\section{Slots}{

\describe{
\item{\code{Results}}{A dataframe containg the estimated Hazard ratio of the test dataset and the training dataset}

\item{\code{Ncv}}{The number of cross validation performed}

\item{\code{Method}}{The dimesion reduction method used}

\item{\code{CVtrain}}{The training dataset indices matrix used for the cross validation}

\item{\code{CVtest}}{The test dataset indices matrix used for the cross validation}

\item{\code{Select}}{The number of taxa used for the dimesion reduction method used}
}}

\seealso{
\code{\link[MicrobiomeSurv]{CVPcaPls}}, \code{\link[MicrobiomeSurv]{SurvPcaClass}}, \code{\link[MicrobiomeSurv]{SurvPlsClass}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
