% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_list.R
\docType{class}
\name{ms_list}
\alias{ms_list}
\title{Sharepoint list}
\format{
An R6 object of class \code{ms_list}, inheriting from \code{ms_object}.
}
\description{
Class representing a list in a SharePoint site.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for the parent drive.
\item \code{type}: always "list" for a SharePoint list object.
\item \code{properties}: The item properties (metadata).
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete this list. By default, ask for confirmation first.
\item \code{update(...)}: Update the list's properties in Microsoft Graph.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the list.
\item \code{sync_fields()}: Synchronise the R object with the list metadata in Microsoft Graph.
\item \code{list_items(filter, select, all_metadata, as_data_frame, pagesize)}: Queries the list and returns items as a data frame. See 'List querying' below.
\item \code{get_column_info()}: Return a data frame containing metadata on the columns (fields) in the list.
\item \code{get_item(id)}: Get an individual list item.
\item \code{create_item(...)}: Create a new list item, using the named arguments as fields.
\item \code{update_item(id, ...)}: Update the \emph{data} fields in the given item, using the named arguments. To update the item's metadata, use \code{get_item()} to retrieve the item object, then call its \code{update()} method.
\item \code{delete_item(confirm=TRUE)}: Delete a list item. By default, ask for confirmation first.
\item \code{bulk_import(data)}: Imports a data frame into the list.
}
}

\section{Initialization}{

Creating new objects of this class should be done via the \code{get_list} method of the \code{\link{ms_site}} class. Calling the \code{new()} method for this class only constructs the R object; it does not call the Microsoft Graph API to retrieve or create the actual item.
}

\section{List querying}{

\code{list_items} supports the following arguments to customise results returned by the query.
\itemize{
\item \code{filter}: A string giving an \href{https://learn.microsoft.com/en-us/graph/query-parameters#filter-parameter}{OData expression} to filter the rows to return. Note that column names used in the expression must be prefixed with \verb{fields/} to distinguish them from item metadata.
\item \code{n}: The maximum number of (filtered) results to return. If this is NULL, the \code{ms_graph_pager} iterator object is returned instead to allow manual iteration over the results.
\item \code{select}: A string containing comma-separated column names to include in the returned data frame. If not supplied, includes all columns.
\item \code{all_metadata}: If TRUE, the returned data frame will contain extended metadata as separate columns, while the data fields will be in a nested data frame named \code{fields}. This is always set to FALSE if \code{n=NULL} or \code{as_data_frame=FALSE}.
\item \code{as_data_frame}: If FALSE, return the result as a list of individual \code{ms_list_item} objects, rather than a data frame.
\item \code{pagesize}: The number of results to return for each call to the REST endpoint. You can try reducing this argument below the default of 5000 if you are experiencing timeouts.
}

Note that the Graph API currently doesn't support retrieving item attachments.
}

\examples{
\dontrun{

site <- get_sharepoint_site("My site")
lst <- site$get_list("mylist")

lst$get_column_info()

lst$list_items()
lst$list_items(filter="startswith(fields/firstname, 'John')", select="firstname,lastname")

lst$create_item(firstname="Mary", lastname="Smith")
lst$get_item("item-id")
lst$update_item("item_id", firstname="Eliza")
lst$delete_item("item_id")

df <- data.frame(
    firstname=c("Satya", "Mark", "Tim", "Jeff", "Sundar"),
    lastname=c("Nadella", "Zuckerberg", "Cook", "Bezos", "Pichai")
)
lst$bulk_import(df)

}
}
\seealso{
\code{\link{get_sharepoint_site}}, \code{\link{ms_site}}, \code{\link{ms_list_item}}

\href{https://learn.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://learn.microsoft.com/en-us/graph/api/resources/sharepoint?view=graph-rest-1.0}{SharePoint sites API reference}
}
