% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLMLE.R
\name{mlmle}
\alias{mlmle}
\title{Maximum Likelihood Estimation of the Mittag-Leffler distribution}
\usage{
mlmle(data, ...)
}
\arguments{
\item{data}{Vector of class "numeric"}

\item{...}{Additional parameters passed on to \code{\link{optim}}.}
}
\value{
The output of \code{\link{optim}}.
}
\description{
Optimizes the bivariate loglikelihood of the Mittag-Leffler distribution
 via \code{\link{optim}}. Uses \code{\link{logMomentEstimator}}
for initial parameter values.
}
\examples{
library(magrittr)
rml(n = 100, tail = 0.8, scale = 1000) \%>\% mlmle()
}
