% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing_data.R
\name{analyse_stable_distribution}
\alias{analyse_stable_distribution}
\title{Perform full stability analysis and export results}
\usage{
analyse_stable_distribution(
  x,
  filename = "interval_analysis",
  qcv_threshold = 1.8,
  fig_path = NULL,
  verbose = FALSE
)
}
\arguments{
\item{x}{Numeric vector of data.}

\item{filename}{Base name for output files (JSON and Excel). Written to tempdir().}

\item{qcv_threshold}{Threshold for QCV to consider distribution heavy-tailed.}

\item{fig_path}{Optional path to save the plot (PNG). If NULL, uses tempdir().}

\item{verbose}{Logical; if TRUE, prints progress messages. Default is FALSE.}
}
\value{
Invisibly returns a character string containing a Markdown-formatted summary report.
}
\description{
Executes the full pipeline for stability analysis: normality tests, QCV computation,
parameter estimation, plotting, and report export.
}
