#'@title Asymmetric Third Order Designs for sequential experimentation
#' @name Asymseq
#' @param v Total number of input factors
#' @return Third order design in two blocks
#' @description Generates asymmetric sequential third order design for v  (3 <= v <= 9) factors in two blocks. Block I gives a second order design for the first stage of the experimentation. If lack of fit of the second order model is found to be significant, then further experimentation can be done with the design given in block II. Runs from block-I and block-II combined form a third order design. It also gives G-efficiency of the third order design.
#' @note
#' The user is given with a set of mixed level response surface designs and after entering the serial number of any of the designs from the displayed set, the chosen design will be generated and displayed.
#' @examples
#'if(interactive()){
#'library(MixedLevelRSDs)
#'Asymseq(4)
#'}
#'@references
#'1)	G.E.P. Box and K.B. Wilson (1951). " On the experimental attainment of optimum conditions".
#'
#'2)	 J.S. Mehta and M.N. Das (1968). "Asymmetric rotatable designs and orthogonal transformations".
#'
#'3)	M. Hemavathi, Shashi Shekhar, Eldho Varghese, Seema Jaggi, Bikas Sinha & Nripes Kumar   Mandal (2022)<doi: 10.1080/03610926.2021.1944213>." Theoretical developments in response surface designs: an informative review and further thoughts".
#'
#'4)	M. Hemavathi, Eldho Varghese, Shashi Shekhar & Seema Jaggi (2020) <doi: 10.1080/02664763.2020.1864817>. "Sequential asymmetric third order rotatable designs (SATORDs)".
#' @export
Asymseq<-function(v){
  #################
  SeqTORD<-function(v){

    if(v==3){
      B1<-matrix(c(1	,	1	,	-1	,
                   1	,	-1	,	1	,
                   -1	,	1	,	1	,
                   -1	,	-1	,	-1	,
                   2	,	0	,	0	,
                   -2	,	0	,	0	,
                   0	,	2	,	0	,
                   0	,	-2	,	0	,
                   0	,	0	,	2	,
                   0	,	0	,	-2	,
                   0	,	0	,	0	,
                   0	,	0	,	0	,
                   0	,	0	,	0	),nrow=13,byrow=T)

      B2<-matrix(c(1	,	1	,	0	,
                   1	,	-1	,	0	,
                   -1	,	1	,	0	,
                   -1	,	-1	,	0	,
                   1	,	0	,	1	,
                   1	,	0	,	-1	,
                   -1	,	0	,	1	,
                   -1	,	0	,	-1	,
                   0	,	1	,	1	,
                   0	,	1	,	-1	,
                   0	,	-1	,	1	,
                   0	,	-1	,	-1	,
                   0	,	0	,	0	,
                   0	,	0	,	0	,
                   0	,	0	,	0	),nrow=15,byrow=T)

      # lm=list("Block 1"= B1, "Block 2"= B2)
      # return(lm)
    }
    if(v==4){
      B1<-matrix(c(1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	-1	,
                   1	,	1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,
                   1	,	-1	,	1	,	1	,
                   1	,	-1	,	1	,	-1	,
                   1	,	-1	,	-1	,	1	,
                   1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	1	,	1	,
                   -1	,	1	,	1	,	-1	,
                   -1	,	1	,	-1	,	1	,
                   -1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	1	,
                   -1	,	-1	,	-1	,	-1	,
                   2	,	0	,	0	,	0	,
                   -2	,	0	,	0	,	0	,
                   0	,	2	,	0	,	0	,
                   0	,	-2	,	0	,	0	,
                   0	,	0	,	2	,	0	,
                   0	,	0	,	-2	,	0	,
                   0	,	0	,	0	,	2	,
                   0	,	0	,	0	,	-2	,
                   0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	),nrow=27,byrow=T)
      B2<-matrix(c(1	,	1	,	0	,	0	,
                   1	,	-1	,	0	,	0	,
                   -1	,	1	,	0	,	0	,
                   -1	,	-1	,	0	,	0	,
                   1	,	0	,	1	,	0	,
                   1	,	0	,	-1	,	0	,
                   -1	,	0	,	1	,	0	,
                   -1	,	0	,	-1	,	0	,
                   1	,	0	,	0	,	1	,
                   1	,	0	,	0	,	-1	,
                   -1	,	0	,	0	,	1	,
                   -1	,	0	,	0	,	-1	,
                   0	,	1	,	1	,	0	,
                   0	,	1	,	-1	,	0	,
                   0	,	-1	,	1	,	0	,
                   0	,	-1	,	-1	,	0	,
                   0	,	1	,	0	,	1	,
                   0	,	1	,	0	,	-1	,
                   0	,	-1	,	0	,	1	,
                   0	,	-1	,	0	,	-1	,
                   0	,	0	,	1	,	1	,
                   0	,	0	,	1	,	-1	,
                   0	,	0	,	-1	,	1	,
                   0	,	0	,	-1	,	-1	,
                   0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	),nrow=27,byrow=T)
      # lm=list("Block 1"=B1, "Block 2"=B2)
      # return(lm)
    }
    if(v==5){
      B1<-matrix(c(-1	,	-1	,	-1	,	-1	,	1	,
                   1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	-1	,
                   1	,	1	,	-1	,	-1	,	1	,
                   -1	,	-1	,	1	,	-1	,	-1	,
                   1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	-1	,
                   1	,	-1	,	-1	,	1	,	1	,
                   -1	,	1	,	-1	,	1	,	1	,
                   1	,	1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	1	,	1	,	1	,
                   1	,	-1	,	1	,	1	,	-1	,
                   -1	,	1	,	1	,	1	,	-1	,
                   1	,	1	,	1	,	1	,	1	,
                   2	,	0	,	0	,	0	,	0	,
                   -2	,	0	,	0	,	0	,	0	,
                   0	,	2	,	0	,	0	,	0	,
                   0	,	-2	,	0	,	0	,	0	,
                   0	,	0	,	2	,	0	,	0	,
                   0	,	0	,	-2	,	0	,	0	,
                   0	,	0	,	0	,	2	,	0	,
                   0	,	0	,	0	,	-2	,	0	,
                   0	,	0	,	0	,	0	,	2	,
                   0	,	0	,	0	,	0	,	-2	,
                   0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	),nrow=30,byrow=T)
      B2<-matrix(c(1	,	1	,	0	,	0	,	0	,
                   1	,	-1	,	0	,	0	,	0	,
                   -1	,	1	,	0	,	0	,	0	,
                   -1	,	-1	,	0	,	0	,	0	,
                   1	,	0	,	1	,	0	,	0	,
                   1	,	0	,	-1	,	0	,	0	,
                   -1	,	0	,	1	,	0	,	0	,
                   -1	,	0	,	-1	,	0	,	0	,
                   1	,	0	,	0	,	1	,	0	,
                   1	,	0	,	0	,	-1	,	0	,
                   -1	,	0	,	0	,	1	,	0	,
                   -1	,	0	,	0	,	-1	,	0	,
                   1	,	0	,	0	,	0	,	1	,
                   1	,	0	,	0	,	0	,	-1	,
                   -1	,	0	,	0	,	0	,	1	,
                   -1	,	0	,	0	,	0	,	-1	,
                   0	,	1	,	1	,	0	,	0	,
                   0	,	1	,	-1	,	0	,	0	,
                   0	,	-1	,	1	,	0	,	0	,
                   0	,	-1	,	-1	,	0	,	0	,
                   0	,	1	,	0	,	1	,	0	,
                   0	,	1	,	0	,	-1	,	0	,
                   0	,	-1	,	0	,	1	,	0	,
                   0	,	-1	,	0	,	-1	,	0	,
                   0	,	1	,	0	,	0	,	1	,
                   0	,	1	,	0	,	0	,	-1	,
                   0	,	-1	,	0	,	0	,	1	,
                   0	,	-1	,	0	,	0	,	-1	,
                   0	,	0	,	1	,	1	,	0	,
                   0	,	0	,	1	,	-1	,	0	,
                   0	,	0	,	-1	,	1	,	0	,
                   0	,	0	,	-1	,	-1	,	0	,
                   0	,	0	,	1	,	0	,	1	,
                   0	,	0	,	1	,	0	,	-1	,
                   0	,	0	,	-1	,	0	,	1	,
                   0	,	0	,	-1	,	0	,	-1	,
                   0	,	0	,	0	,	1	,	1	,
                   0	,	0	,	0	,	1	,	-1	,
                   0	,	0	,	0	,	-1	,	1	,
                   0	,	0	,	0	,	-1	,	-1	,
                   0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	),nrow=43,byrow=T)
      # lm=list("Block 1"=B1, "Block 2"=B2)
      # return(lm)
    }
    if(v==6){
      B1<-matrix(c(-1	,	1	,	1	,	-1	,	1	,	1	,
                   -1	,	1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	1	,
                   1	,	1	,	1	,	-1	,	1	,	-1	,
                   1	,	-1	,	-1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	-1	,	-1	,
                   1	,	1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	-1	,	-1	,	1	,	-1	,
                   1	,	1	,	-1	,	1	,	1	,	-1	,
                   -1	,	1	,	1	,	1	,	1	,	-1	,
                   1	,	1	,	-1	,	-1	,	1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	1	,
                   1	,	-1	,	1	,	1	,	1	,	-1	,
                   -1	,	1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   1	,	-1	,	1	,	-1	,	1	,	1	,
                   1	,	1	,	1	,	-1	,	-1	,	1	,
                   -1	,	-1	,	1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	1	,	1	,	1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	1	,
                   1	,	-1	,	1	,	1	,	-1	,	1	,
                   -1	,	1	,	-1	,	1	,	1	,	1	,
                   1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	1	,	-1	,	1	,	-1	,
                   1	,	1	,	1	,	1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	1	,
                   1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	1	,	-1	,
                   -1	,	1	,	-1	,	1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   2.743977	,	0	,	0	,	0	,	0	,	0	,
                   -2.743977	,	0	,	0	,	0	,	0	,	0	,
                   0	,	2.743977	,	0	,	0	,	0	,	0	,
                   0	,	-2.743977	,	0	,	0	,	0	,	0	,
                   0	,	0	,	2.743977	,	0	,	0	,	0	,
                   0	,	0	,	-2.743977	,	0	,	0	,	0	,
                   0	,	0	,	0	,	2.743977	,	0	,	0	,
                   0	,	0	,	0	,	-2.743977	,	0	,	0	,
                   0	,	0	,	0	,	0	,	2.743977	,	0	,
                   0	,	0	,	0	,	0	,	-2.743977	,	0	,
                   0	,	0	,	0	,	0	,	0	,	2.743977	,
                   0	,	0	,	0	,	0	,	0	,	-2.743977	,
                   0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	),nrow=47,byrow=T)
      B2<-matrix(c(1	,	1	,	0	,	-1	,	0	,	0	,
                   -1	,	1	,	0	,	-1	,	0	,	0	,
                   -1	,	1	,	0	,	1	,	0	,	0	,
                   -1	,	-1	,	0	,	1	,	0	,	0	,
                   1	,	-1	,	0	,	-1	,	0	,	0	,
                   1	,	-1	,	0	,	1	,	0	,	0	,
                   1	,	1	,	0	,	1	,	0	,	0	,
                   -1	,	-1	,	0	,	-1	,	0	,	0	,
                   0	,	1	,	1	,	0	,	-1	,	0	,
                   0	,	-1	,	1	,	0	,	-1	,	0	,
                   0	,	-1	,	1	,	0	,	1	,	0	,
                   0	,	-1	,	-1	,	0	,	1	,	0	,
                   0	,	1	,	-1	,	0	,	-1	,	0	,
                   0	,	1	,	-1	,	0	,	1	,	0	,
                   0	,	1	,	1	,	0	,	1	,	0	,
                   0	,	-1	,	-1	,	0	,	-1	,	0	,
                   -1	,	0	,	1	,	1	,	0	,	0	,
                   -1	,	0	,	-1	,	1	,	0	,	0	,
                   1	,	0	,	-1	,	1	,	0	,	0	,
                   1	,	0	,	-1	,	-1	,	0	,	0	,
                   -1	,	0	,	1	,	-1	,	0	,	0	,
                   1	,	0	,	1	,	-1	,	0	,	0	,
                   1	,	0	,	1	,	1	,	0	,	0	,
                   -1	,	0	,	-1	,	-1	,	0	,	0	,
                   0	,	-1	,	0	,	1	,	1	,	0	,
                   0	,	-1	,	0	,	-1	,	1	,	0	,
                   0	,	1	,	0	,	-1	,	1	,	0	,
                   0	,	1	,	0	,	-1	,	-1	,	0	,
                   0	,	-1	,	0	,	1	,	-1	,	0	,
                   0	,	1	,	0	,	1	,	-1	,	0	,
                   0	,	1	,	0	,	1	,	1	,	0	,
                   0	,	-1	,	0	,	-1	,	-1	,	0	,
                   1	,	0	,	-1	,	0	,	1	,	0	,
                   1	,	0	,	-1	,	0	,	-1	,	0	,
                   1	,	0	,	1	,	0	,	-1	,	0	,
                   -1	,	0	,	1	,	0	,	-1	,	0	,
                   -1	,	0	,	-1	,	0	,	1	,	0	,
                   -1	,	0	,	1	,	0	,	1	,	0	,
                   1	,	0	,	1	,	0	,	1	,	0	,
                   -1	,	0	,	-1	,	0	,	-1	,	0	,
                   1	,	-1	,	0	,	0	,	0	,	1	,
                   1	,	-1	,	0	,	0	,	0	,	-1	,
                   1	,	1	,	0	,	0	,	0	,	-1	,
                   -1	,	1	,	0	,	0	,	0	,	-1	,
                   -1	,	-1	,	0	,	0	,	0	,	1	,
                   -1	,	1	,	0	,	0	,	0	,	1	,
                   1	,	1	,	0	,	0	,	0	,	1	,
                   -1	,	-1	,	0	,	0	,	0	,	-1	,
                   0	,	1	,	-1	,	0	,	0	,	1	,
                   0	,	1	,	-1	,	0	,	0	,	-1	,
                   0	,	1	,	1	,	0	,	0	,	-1	,
                   0	,	-1	,	1	,	0	,	0	,	-1	,
                   0	,	-1	,	-1	,	0	,	0	,	1	,
                   0	,	-1	,	1	,	0	,	0	,	1	,
                   0	,	1	,	1	,	0	,	0	,	1	,
                   0	,	-1	,	-1	,	0	,	0	,	-1	,
                   0	,	0	,	1	,	-1	,	0	,	1	,
                   0	,	0	,	1	,	-1	,	0	,	-1	,
                   0	,	0	,	1	,	1	,	0	,	-1	,
                   0	,	0	,	-1	,	1	,	0	,	-1	,
                   0	,	0	,	-1	,	-1	,	0	,	1	,
                   0	,	0	,	-1	,	1	,	0	,	1	,
                   0	,	0	,	1	,	1	,	0	,	1	,
                   0	,	0	,	-1	,	-1	,	0	,	-1	,
                   0	,	0	,	0	,	1	,	-1	,	1	,
                   0	,	0	,	0	,	1	,	-1	,	-1	,
                   0	,	0	,	0	,	1	,	1	,	-1	,
                   0	,	0	,	0	,	-1	,	1	,	-1	,
                   0	,	0	,	0	,	-1	,	-1	,	1	,
                   0	,	0	,	0	,	-1	,	1	,	1	,
                   0	,	0	,	0	,	1	,	1	,	1	,
                   0	,	0	,	0	,	-1	,	-1	,	-1	,
                   -1	,	0	,	0	,	0	,	1	,	1	,
                   -1	,	0	,	0	,	0	,	1	,	-1	,
                   1	,	0	,	0	,	0	,	1	,	-1	,
                   1	,	0	,	0	,	0	,	-1	,	-1	,
                   -1	,	0	,	0	,	0	,	-1	,	1	,
                   1	,	0	,	0	,	0	,	-1	,	1	,
                   1	,	0	,	0	,	0	,	1	,	1	,
                   -1	,	0	,	0	,	0	,	-1	,	-1	,
                   0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	),nrow=83,byrow=T)
      # lm=list("Block 1"=B1, "Block 2"=B2)
      # return(lm)
    }
    if(v==7){
      B1<-matrix(c(-1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                   1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                   -1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                   -1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                   -1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                   -1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                   -1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                   1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                   1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                   1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                   -1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	1	,	1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                   1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                   1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                   1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                   1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                   1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                   -1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                   1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                   1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                   1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                   -1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                   -1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                   1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                   2.64575131	,	0	,	0	,	0	,	0	,	0	,	0	,
                   -2.64575131	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	2.64575131	,	0	,	0	,	0	,	0	,	0	,
                   0	,	-2.64575131	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	2.64575131	,	0	,	0	,	0	,	0	,
                   0	,	0	,	-2.64575131	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	2.64575131	,	0	,	0	,	0	,
                   0	,	0	,	0	,	-2.64575131	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	2.64575131	,	0	,	0	,
                   0	,	0	,	0	,	0	,	-2.64575131	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	2.64575131	,	0	,
                   0	,	0	,	0	,	0	,	0	,	-2.64575131	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	2.64575131	,
                   0	,	0	,	0	,	0	,	0	,	0	,	-2.64575131	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	),nrow=82,byrow=T)
      B2<-matrix(c(1	,	0	,	1	,	0	,	0	,	0	,	0	,
                   1	,	0	,	-1	,	0	,	0	,	0	,	0	,
                   -1	,	0	,	1	,	0	,	0	,	0	,	0	,
                   -1	,	0	,	-1	,	0	,	0	,	0	,	0	,
                   0	,	0	,	1	,	0	,	0	,	1	,	0	,
                   0	,	0	,	1	,	0	,	0	,	-1	,	0	,
                   0	,	0	,	-1	,	0	,	0	,	1	,	0	,
                   0	,	0	,	-1	,	0	,	0	,	-1	,	0	,
                   1	,	0	,	0	,	1	,	0	,	0	,	0	,
                   1	,	0	,	0	,	-1	,	0	,	0	,	0	,
                   -1	,	0	,	0	,	1	,	0	,	0	,	0	,
                   -1	,	0	,	0	,	-1	,	0	,	0	,	0	,
                   0	,	0	,	1	,	0	,	0	,	0	,	1	,
                   0	,	0	,	1	,	0	,	0	,	0	,	-1	,
                   0	,	0	,	-1	,	0	,	0	,	0	,	1	,
                   0	,	0	,	-1	,	0	,	0	,	0	,	-1	,
                   1	,	0	,	0	,	0	,	1	,	0	,	0	,
                   1	,	0	,	0	,	0	,	-1	,	0	,	0	,
                   -1	,	0	,	0	,	0	,	1	,	0	,	0	,
                   -1	,	0	,	0	,	0	,	-1	,	0	,	0	,
                   1	,	0	,	0	,	0	,	0	,	1	,	0	,
                   1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                   -1	,	0	,	0	,	0	,	0	,	1	,	0	,
                   -1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                   0	,	0	,	0	,	1	,	0	,	0	,	1	,
                   0	,	0	,	0	,	1	,	0	,	0	,	-1	,
                   0	,	0	,	0	,	-1	,	0	,	0	,	1	,
                   0	,	0	,	0	,	-1	,	0	,	0	,	-1	,
                   0	,	0	,	0	,	1	,	0	,	1	,	0	,
                   0	,	0	,	0	,	1	,	0	,	-1	,	0	,
                   0	,	0	,	0	,	-1	,	0	,	1	,	0	,
                   0	,	0	,	0	,	-1	,	0	,	-1	,	0	,
                   1	,	0	,	0	,	0	,	0	,	0	,	1	,
                   1	,	0	,	0	,	0	,	0	,	0	,	-1	,
                   -1	,	0	,	0	,	0	,	0	,	0	,	1	,
                   -1	,	0	,	0	,	0	,	0	,	0	,	-1	,
                   0	,	0	,	0	,	0	,	0	,	1	,	1	,
                   0	,	0	,	0	,	0	,	0	,	1	,	-1	,
                   0	,	0	,	0	,	0	,	0	,	-1	,	1	,
                   0	,	0	,	0	,	0	,	0	,	-1	,	-1	,
                   0	,	0	,	0	,	0	,	1	,	0	,	1	,
                   0	,	0	,	0	,	0	,	1	,	0	,	-1	,
                   0	,	0	,	0	,	0	,	-1	,	0	,	1	,
                   0	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                   0	,	0	,	0	,	0	,	1	,	1	,	0	,
                   0	,	0	,	0	,	0	,	1	,	-1	,	0	,
                   0	,	0	,	0	,	0	,	-1	,	1	,	0	,
                   0	,	0	,	0	,	0	,	-1	,	-1	,	0	,
                   0	,	0	,	0	,	1	,	1	,	0	,	0	,
                   0	,	0	,	0	,	1	,	-1	,	0	,	0	,
                   0	,	0	,	0	,	-1	,	1	,	0	,	0	,
                   0	,	0	,	0	,	-1	,	-1	,	0	,	0	,
                   0	,	0	,	1	,	0	,	1	,	0	,	0	,
                   0	,	0	,	1	,	0	,	-1	,	0	,	0	,
                   0	,	0	,	-1	,	0	,	1	,	0	,	0	,
                   0	,	0	,	-1	,	0	,	-1	,	0	,	0	,
                   0	,	0	,	1	,	1	,	0	,	0	,	0	,
                   0	,	0	,	1	,	-1	,	0	,	0	,	0	,
                   0	,	0	,	-1	,	1	,	0	,	0	,	0	,
                   0	,	0	,	-1	,	-1	,	0	,	0	,	0	,
                   0	,	1	,	0	,	0	,	0	,	0	,	1	,
                   0	,	1	,	0	,	0	,	0	,	0	,	-1	,
                   0	,	-1	,	0	,	0	,	0	,	0	,	1	,
                   0	,	-1	,	0	,	0	,	0	,	0	,	-1	,
                   0	,	1	,	0	,	0	,	0	,	1	,	0	,
                   0	,	1	,	0	,	0	,	0	,	-1	,	0	,
                   0	,	-1	,	0	,	0	,	0	,	1	,	0	,
                   0	,	-1	,	0	,	0	,	0	,	-1	,	0	,
                   1	,	1	,	0	,	0	,	0	,	0	,	0	,
                   1	,	-1	,	0	,	0	,	0	,	0	,	0	,
                   -1	,	1	,	0	,	0	,	0	,	0	,	0	,
                   -1	,	-1	,	0	,	0	,	0	,	0	,	0	,
                   0	,	1	,	0	,	0	,	1	,	0	,	0	,
                   0	,	1	,	0	,	0	,	-1	,	0	,	0	,
                   0	,	-1	,	0	,	0	,	1	,	0	,	0	,
                   0	,	-1	,	0	,	0	,	-1	,	0	,	0	,
                   0	,	1	,	0	,	1	,	0	,	0	,	0	,
                   0	,	1	,	0	,	-1	,	0	,	0	,	0	,
                   0	,	-1	,	0	,	1	,	0	,	0	,	0	,
                   0	,	-1	,	0	,	-1	,	0	,	0	,	0	,
                   0	,	1	,	1	,	0	,	0	,	0	,	0	,
                   0	,	1	,	-1	,	0	,	0	,	0	,	0	,
                   0	,	-1	,	1	,	0	,	0	,	0	,	0	,
                   0	,	-1	,	-1	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	),nrow=87,byrow=T)
      # lm=list("Block 1"=B1, "Block 2"=B2)
      # return(lm)
    }
    if(v==8){
      B1<-matrix(c(-1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	1	,	1	,	1	,
                   -1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                   1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                   1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                   1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                   1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                   1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                   1	,	1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                   -1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                   1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                   1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                   1	,	-1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                   -1	,	1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                   -1	,	1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                   1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                   1	,	1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                   -1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                   1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                   -1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                   -1	,	-1	,	1	,	1	,	1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                   -1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                   -1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                   1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                   1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                   1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                   -1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                   1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                   -1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                   1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                   1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                   -1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                   -1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                   1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                   1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                   -1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                   1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                   -1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                   1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                   1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                   1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                   1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                   -1	,	1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                   1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                   1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                   -1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                   1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                   1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                   -1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   1	,	1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                   1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                   -1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                   -1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   -1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                   -1	,	1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                   1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                   1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                   4	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   -4	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	4	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	-4	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	4	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	-4	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	4	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	-4	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	4	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	-4	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	4	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	-4	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	4	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	-4	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	4	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	-4	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	),nrow=147,byrow=T)
      B2<-matrix(c(1	,	1	,	0	,	1	,	0	,	0	,	1	,	0	,
                   1	,	1	,	0	,	1	,	0	,	0	,	-1	,	0	,
                   1	,	1	,	0	,	-1	,	0	,	0	,	1	,	0	,
                   1	,	1	,	0	,	-1	,	0	,	0	,	-1	,	0	,
                   1	,	-1	,	0	,	1	,	0	,	0	,	1	,	0	,
                   1	,	-1	,	0	,	1	,	0	,	0	,	-1	,	0	,
                   1	,	-1	,	0	,	-1	,	0	,	0	,	1	,	0	,
                   1	,	-1	,	0	,	-1	,	0	,	0	,	-1	,	0	,
                   -1	,	1	,	0	,	1	,	0	,	0	,	1	,	0	,
                   -1	,	1	,	0	,	1	,	0	,	0	,	-1	,	0	,
                   -1	,	1	,	0	,	-1	,	0	,	0	,	1	,	0	,
                   -1	,	1	,	0	,	-1	,	0	,	0	,	-1	,	0	,
                   -1	,	-1	,	0	,	1	,	0	,	0	,	1	,	0	,
                   -1	,	-1	,	0	,	1	,	0	,	0	,	-1	,	0	,
                   -1	,	-1	,	0	,	-1	,	0	,	0	,	1	,	0	,
                   -1	,	-1	,	0	,	-1	,	0	,	0	,	-1	,	0	,
                   1	,	1	,	1	,	0	,	1	,	0	,	0	,	0	,
                   -1	,	1	,	1	,	0	,	1	,	0	,	0	,	0	,
                   1	,	1	,	1	,	0	,	-1	,	0	,	0	,	0	,
                   -1	,	1	,	1	,	0	,	-1	,	0	,	0	,	0	,
                   1	,	1	,	-1	,	0	,	1	,	0	,	0	,	0	,
                   -1	,	1	,	-1	,	0	,	1	,	0	,	0	,	0	,
                   1	,	1	,	-1	,	0	,	-1	,	0	,	0	,	0	,
                   -1	,	1	,	-1	,	0	,	-1	,	0	,	0	,	0	,
                   1	,	-1	,	1	,	0	,	1	,	0	,	0	,	0	,
                   -1	,	-1	,	1	,	0	,	1	,	0	,	0	,	0	,
                   1	,	-1	,	1	,	0	,	-1	,	0	,	0	,	0	,
                   -1	,	-1	,	1	,	0	,	-1	,	0	,	0	,	0	,
                   1	,	-1	,	-1	,	0	,	1	,	0	,	0	,	0	,
                   -1	,	-1	,	-1	,	0	,	1	,	0	,	0	,	0	,
                   1	,	-1	,	-1	,	0	,	-1	,	0	,	0	,	0	,
                   -1	,	-1	,	-1	,	0	,	-1	,	0	,	0	,	0	,
                   0	,	1	,	1	,	1	,	0	,	1	,	0	,	0	,
                   0	,	-1	,	1	,	1	,	0	,	1	,	0	,	0	,
                   0	,	1	,	1	,	1	,	0	,	-1	,	0	,	0	,
                   0	,	-1	,	1	,	1	,	0	,	-1	,	0	,	0	,
                   0	,	1	,	1	,	-1	,	0	,	1	,	0	,	0	,
                   0	,	-1	,	1	,	-1	,	0	,	1	,	0	,	0	,
                   0	,	1	,	1	,	-1	,	0	,	-1	,	0	,	0	,
                   0	,	-1	,	1	,	-1	,	0	,	-1	,	0	,	0	,
                   0	,	1	,	-1	,	1	,	0	,	1	,	0	,	0	,
                   0	,	-1	,	-1	,	1	,	0	,	1	,	0	,	0	,
                   0	,	1	,	-1	,	1	,	0	,	-1	,	0	,	0	,
                   0	,	-1	,	-1	,	1	,	0	,	-1	,	0	,	0	,
                   0	,	1	,	-1	,	-1	,	0	,	1	,	0	,	0	,
                   0	,	-1	,	-1	,	-1	,	0	,	1	,	0	,	0	,
                   0	,	1	,	-1	,	-1	,	0	,	-1	,	0	,	0	,
                   0	,	-1	,	-1	,	-1	,	0	,	-1	,	0	,	0	,
                   0	,	0	,	1	,	1	,	1	,	0	,	1	,	0	,
                   0	,	0	,	-1	,	1	,	1	,	0	,	1	,	0	,
                   0	,	0	,	1	,	1	,	1	,	0	,	-1	,	0	,
                   0	,	0	,	-1	,	1	,	1	,	0	,	-1	,	0	,
                   0	,	0	,	1	,	1	,	-1	,	0	,	1	,	0	,
                   0	,	0	,	-1	,	1	,	-1	,	0	,	1	,	0	,
                   0	,	0	,	1	,	1	,	-1	,	0	,	-1	,	0	,
                   0	,	0	,	-1	,	1	,	-1	,	0	,	-1	,	0	,
                   0	,	0	,	1	,	-1	,	1	,	0	,	1	,	0	,
                   0	,	0	,	-1	,	-1	,	1	,	0	,	1	,	0	,
                   0	,	0	,	1	,	-1	,	1	,	0	,	-1	,	0	,
                   0	,	0	,	-1	,	-1	,	1	,	0	,	-1	,	0	,
                   0	,	0	,	1	,	-1	,	-1	,	0	,	1	,	0	,
                   0	,	0	,	-1	,	-1	,	-1	,	0	,	1	,	0	,
                   0	,	0	,	1	,	-1	,	-1	,	0	,	-1	,	0	,
                   0	,	0	,	-1	,	-1	,	-1	,	0	,	-1	,	0	,
                   1	,	0	,	0	,	1	,	1	,	1	,	0	,	0	,
                   1	,	0	,	0	,	-1	,	1	,	1	,	0	,	0	,
                   -1	,	0	,	0	,	1	,	1	,	1	,	0	,	0	,
                   -1	,	0	,	0	,	-1	,	1	,	1	,	0	,	0	,
                   1	,	0	,	0	,	1	,	1	,	-1	,	0	,	0	,
                   1	,	0	,	0	,	-1	,	1	,	-1	,	0	,	0	,
                   -1	,	0	,	0	,	1	,	1	,	-1	,	0	,	0	,
                   -1	,	0	,	0	,	-1	,	1	,	-1	,	0	,	0	,
                   1	,	0	,	0	,	1	,	-1	,	1	,	0	,	0	,
                   1	,	0	,	0	,	-1	,	-1	,	1	,	0	,	0	,
                   -1	,	0	,	0	,	1	,	-1	,	1	,	0	,	0	,
                   -1	,	0	,	0	,	-1	,	-1	,	1	,	0	,	0	,
                   1	,	0	,	0	,	1	,	-1	,	-1	,	0	,	0	,
                   1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	0	,
                   -1	,	0	,	0	,	1	,	-1	,	-1	,	0	,	0	,
                   -1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	0	,
                   0	,	1	,	0	,	0	,	1	,	1	,	1	,	0	,
                   0	,	1	,	0	,	0	,	-1	,	1	,	1	,	0	,
                   0	,	-1	,	0	,	0	,	1	,	1	,	1	,	0	,
                   0	,	-1	,	0	,	0	,	-1	,	1	,	1	,	0	,
                   0	,	1	,	0	,	0	,	1	,	1	,	-1	,	0	,
                   0	,	1	,	0	,	0	,	-1	,	1	,	-1	,	0	,
                   0	,	-1	,	0	,	0	,	1	,	1	,	-1	,	0	,
                   0	,	-1	,	0	,	0	,	-1	,	1	,	-1	,	0	,
                   0	,	1	,	0	,	0	,	1	,	-1	,	1	,	0	,
                   0	,	1	,	0	,	0	,	-1	,	-1	,	1	,	0	,
                   0	,	-1	,	0	,	0	,	1	,	-1	,	1	,	0	,
                   0	,	-1	,	0	,	0	,	-1	,	-1	,	1	,	0	,
                   0	,	1	,	0	,	0	,	1	,	-1	,	-1	,	0	,
                   0	,	1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,
                   0	,	-1	,	0	,	0	,	1	,	-1	,	-1	,	0	,
                   0	,	-1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,
                   1	,	0	,	1	,	0	,	0	,	1	,	1	,	0	,
                   1	,	0	,	1	,	0	,	0	,	-1	,	1	,	0	,
                   1	,	0	,	-1	,	0	,	0	,	1	,	1	,	0	,
                   1	,	0	,	-1	,	0	,	0	,	-1	,	1	,	0	,
                   -1	,	0	,	1	,	0	,	0	,	1	,	1	,	0	,
                   -1	,	0	,	1	,	0	,	0	,	-1	,	1	,	0	,
                   -1	,	0	,	-1	,	0	,	0	,	1	,	1	,	0	,
                   -1	,	0	,	-1	,	0	,	0	,	-1	,	1	,	0	,
                   1	,	0	,	1	,	0	,	0	,	1	,	-1	,	0	,
                   1	,	0	,	1	,	0	,	0	,	-1	,	-1	,	0	,
                   1	,	0	,	-1	,	0	,	0	,	1	,	-1	,	0	,
                   1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,
                   -1	,	0	,	1	,	0	,	0	,	1	,	-1	,	0	,
                   -1	,	0	,	1	,	0	,	0	,	-1	,	-1	,	0	,
                   -1	,	0	,	-1	,	0	,	0	,	1	,	-1	,	0	,
                   -1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,
                   1	,	1	,	0	,	0	,	0	,	1	,	0	,	1	,
                   1	,	1	,	0	,	0	,	0	,	1	,	0	,	-1	,
                   1	,	1	,	0	,	0	,	0	,	-1	,	0	,	1	,
                   1	,	1	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                   1	,	-1	,	0	,	0	,	0	,	1	,	0	,	1	,
                   1	,	-1	,	0	,	0	,	0	,	1	,	0	,	-1	,
                   1	,	-1	,	0	,	0	,	0	,	-1	,	0	,	1	,
                   1	,	-1	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                   -1	,	1	,	0	,	0	,	0	,	1	,	0	,	1	,
                   -1	,	1	,	0	,	0	,	0	,	1	,	0	,	-1	,
                   -1	,	1	,	0	,	0	,	0	,	-1	,	0	,	1	,
                   -1	,	1	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                   -1	,	-1	,	0	,	0	,	0	,	1	,	0	,	1	,
                   -1	,	-1	,	0	,	0	,	0	,	1	,	0	,	-1	,
                   -1	,	-1	,	0	,	0	,	0	,	-1	,	0	,	1	,
                   -1	,	-1	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                   0	,	1	,	1	,	0	,	0	,	0	,	1	,	1	,
                   0	,	1	,	1	,	0	,	0	,	0	,	1	,	-1	,
                   0	,	1	,	1	,	0	,	0	,	0	,	-1	,	1	,
                   0	,	1	,	1	,	0	,	0	,	0	,	-1	,	-1	,
                   0	,	1	,	-1	,	0	,	0	,	0	,	1	,	1	,
                   0	,	1	,	-1	,	0	,	0	,	0	,	1	,	-1	,
                   0	,	1	,	-1	,	0	,	0	,	0	,	-1	,	1	,
                   0	,	1	,	-1	,	0	,	0	,	0	,	-1	,	-1	,
                   0	,	-1	,	1	,	0	,	0	,	0	,	1	,	1	,
                   0	,	-1	,	1	,	0	,	0	,	0	,	1	,	-1	,
                   0	,	-1	,	1	,	0	,	0	,	0	,	-1	,	1	,
                   0	,	-1	,	1	,	0	,	0	,	0	,	-1	,	-1	,
                   0	,	-1	,	-1	,	0	,	0	,	0	,	1	,	1	,
                   0	,	-1	,	-1	,	0	,	0	,	0	,	1	,	-1	,
                   0	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	1	,
                   0	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	-1	,
                   1	,	0	,	1	,	1	,	0	,	0	,	0	,	1	,
                   1	,	0	,	1	,	1	,	0	,	0	,	0	,	-1	,
                   -1	,	0	,	1	,	1	,	0	,	0	,	0	,	1	,
                   -1	,	0	,	1	,	1	,	0	,	0	,	0	,	-1	,
                   1	,	0	,	1	,	-1	,	0	,	0	,	0	,	1	,
                   1	,	0	,	1	,	-1	,	0	,	0	,	0	,	-1	,
                   -1	,	0	,	1	,	-1	,	0	,	0	,	0	,	1	,
                   -1	,	0	,	1	,	-1	,	0	,	0	,	0	,	-1	,
                   1	,	0	,	-1	,	1	,	0	,	0	,	0	,	1	,
                   1	,	0	,	-1	,	1	,	0	,	0	,	0	,	-1	,
                   -1	,	0	,	-1	,	1	,	0	,	0	,	0	,	1	,
                   -1	,	0	,	-1	,	1	,	0	,	0	,	0	,	-1	,
                   1	,	0	,	-1	,	-1	,	0	,	0	,	0	,	1	,
                   1	,	0	,	-1	,	-1	,	0	,	0	,	0	,	-1	,
                   -1	,	0	,	-1	,	-1	,	0	,	0	,	0	,	1	,
                   -1	,	0	,	-1	,	-1	,	0	,	0	,	0	,	-1	,
                   0	,	1	,	0	,	1	,	1	,	0	,	0	,	1	,
                   0	,	1	,	0	,	1	,	1	,	0	,	0	,	-1	,
                   0	,	-1	,	0	,	1	,	1	,	0	,	0	,	1	,
                   0	,	-1	,	0	,	1	,	1	,	0	,	0	,	-1	,
                   0	,	1	,	0	,	1	,	-1	,	0	,	0	,	1	,
                   0	,	1	,	0	,	1	,	-1	,	0	,	0	,	-1	,
                   0	,	-1	,	0	,	1	,	-1	,	0	,	0	,	1	,
                   0	,	-1	,	0	,	1	,	-1	,	0	,	0	,	-1	,
                   0	,	1	,	0	,	-1	,	1	,	0	,	0	,	1	,
                   0	,	1	,	0	,	-1	,	1	,	0	,	0	,	-1	,
                   0	,	-1	,	0	,	-1	,	1	,	0	,	0	,	1	,
                   0	,	-1	,	0	,	-1	,	1	,	0	,	0	,	-1	,
                   0	,	1	,	0	,	-1	,	-1	,	0	,	0	,	1	,
                   0	,	1	,	0	,	-1	,	-1	,	0	,	0	,	-1	,
                   0	,	-1	,	0	,	-1	,	-1	,	0	,	0	,	1	,
                   0	,	-1	,	0	,	-1	,	-1	,	0	,	0	,	-1	,
                   0	,	0	,	1	,	0	,	1	,	1	,	0	,	1	,
                   0	,	0	,	1	,	0	,	1	,	1	,	0	,	-1	,
                   0	,	0	,	-1	,	0	,	1	,	1	,	0	,	1	,
                   0	,	0	,	-1	,	0	,	1	,	1	,	0	,	-1	,
                   0	,	0	,	1	,	0	,	1	,	-1	,	0	,	1	,
                   0	,	0	,	1	,	0	,	1	,	-1	,	0	,	-1	,
                   0	,	0	,	-1	,	0	,	1	,	-1	,	0	,	1	,
                   0	,	0	,	-1	,	0	,	1	,	-1	,	0	,	-1	,
                   0	,	0	,	1	,	0	,	-1	,	1	,	0	,	1	,
                   0	,	0	,	1	,	0	,	-1	,	1	,	0	,	-1	,
                   0	,	0	,	-1	,	0	,	-1	,	1	,	0	,	1	,
                   0	,	0	,	-1	,	0	,	-1	,	1	,	0	,	-1	,
                   0	,	0	,	1	,	0	,	-1	,	-1	,	0	,	1	,
                   0	,	0	,	1	,	0	,	-1	,	-1	,	0	,	-1	,
                   0	,	0	,	-1	,	0	,	-1	,	-1	,	0	,	1	,
                   0	,	0	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,
                   0	,	0	,	0	,	1	,	0	,	1	,	1	,	1	,
                   0	,	0	,	0	,	1	,	0	,	1	,	1	,	-1	,
                   0	,	0	,	0	,	-1	,	0	,	1	,	1	,	1	,
                   0	,	0	,	0	,	-1	,	0	,	1	,	1	,	-1	,
                   0	,	0	,	0	,	1	,	0	,	1	,	-1	,	1	,
                   0	,	0	,	0	,	1	,	0	,	1	,	-1	,	-1	,
                   0	,	0	,	0	,	-1	,	0	,	1	,	-1	,	1	,
                   0	,	0	,	0	,	-1	,	0	,	1	,	-1	,	-1	,
                   0	,	0	,	0	,	1	,	0	,	-1	,	1	,	1	,
                   0	,	0	,	0	,	1	,	0	,	-1	,	1	,	-1	,
                   0	,	0	,	0	,	-1	,	0	,	-1	,	1	,	1	,
                   0	,	0	,	0	,	-1	,	0	,	-1	,	1	,	-1	,
                   0	,	0	,	0	,	1	,	0	,	-1	,	-1	,	1	,
                   0	,	0	,	0	,	1	,	0	,	-1	,	-1	,	-1	,
                   0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,	1	,
                   0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,
                   1	,	0	,	0	,	0	,	1	,	0	,	1	,	1	,
                   1	,	0	,	0	,	0	,	1	,	0	,	1	,	-1	,
                   1	,	0	,	0	,	0	,	-1	,	0	,	1	,	1	,
                   1	,	0	,	0	,	0	,	-1	,	0	,	1	,	-1	,
                   -1	,	0	,	0	,	0	,	1	,	0	,	1	,	1	,
                   -1	,	0	,	0	,	0	,	1	,	0	,	1	,	-1	,
                   -1	,	0	,	0	,	0	,	-1	,	0	,	1	,	1	,
                   -1	,	0	,	0	,	0	,	-1	,	0	,	1	,	-1	,
                   1	,	0	,	0	,	0	,	1	,	0	,	-1	,	1	,
                   1	,	0	,	0	,	0	,	1	,	0	,	-1	,	-1	,
                   1	,	0	,	0	,	0	,	-1	,	0	,	-1	,	1	,
                   1	,	0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
                   -1	,	0	,	0	,	0	,	1	,	0	,	-1	,	1	,
                   -1	,	0	,	0	,	0	,	1	,	0	,	-1	,	-1	,
                   -1	,	0	,	0	,	0	,	-1	,	0	,	-1	,	1	,
                   -1	,	0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	),nrow=228,byrow=T)
      # lm=list("Block 1"=B1, "Block 2"=B2)
      # return(lm)
    }
    if(v==9){
      B1<-matrix(c(-1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                   1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                   1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                   -1	,	1	,	1	,	1	,	1	,	1	,	1	,	1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                   1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	1	,	1	,	1	,	1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                   -1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                   1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                   1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                   1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                   -1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                   1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                   -1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                   1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                   1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                   -1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                   1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                   -1	,	1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                   1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                   1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                   1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                   1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                   1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                   1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                   -1	,	1	,	1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                   1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                   -1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                   1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                   1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                   1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                   1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                   1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                   1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                   -1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                   1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                   -1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                   1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   -1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                   -1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                   1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                   1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                   1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                   -1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                   -1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                   1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                   1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                   1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                   1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                   1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                   -1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	1	,	1	,
                   1	,	1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                   -1	,	1	,	-1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                   1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                   1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                   -1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                   -1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                   1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                   -1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                   -1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                   1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                   -1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                   -1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                   -1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                   -1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                   1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                   1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                   1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                   -1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                   -1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                   1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                   1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                   -1	,	1	,	1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                   -1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                   1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                   -1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                   1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                   -1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   1	,	1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                   -1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                   1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                   -1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                   1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                   -1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                   1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   1	,	1	,	-1	,	1	,	1	,	1	,	1	,	1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                   1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                   1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                   1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                   -1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                   -1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                   -1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                   -1	,	-1	,	1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                   1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                   1	,	1	,	1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                   -1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                   1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                   -1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                   -1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                   1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                   -1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                   -1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   -1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                   1	,	1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                   -1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                   -1	,	1	,	1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                   -1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                   1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                   1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                   1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                   1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                   -1	,	1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                   1	,	1	,	1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                   1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                   1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                   1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                   1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                   -1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                   4.75682846	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   -4.75682846	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	4.75682846	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	-4.75682846	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	4.75682846	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	-4.75682846	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	4.75682846	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	-4.75682846	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	4.75682846	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	-4.75682846	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	4.75682846	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	-4.75682846	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	4.75682846	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	-4.75682846	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	4.75682846	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	-4.75682846	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	4.75682846	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	-4.75682846	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	),nrow=277,byrow=T)
      B2<-matrix(c(1	,	0	,	1	,	0	,	0	,	1	,	1	,	0	,	0	,
                   1	,	0	,	1	,	0	,	0	,	1	,	-1	,	0	,	0	,
                   1	,	0	,	1	,	0	,	0	,	-1	,	1	,	0	,	0	,
                   1	,	0	,	1	,	0	,	0	,	-1	,	-1	,	0	,	0	,
                   1	,	0	,	-1	,	0	,	0	,	1	,	1	,	0	,	0	,
                   1	,	0	,	-1	,	0	,	0	,	1	,	-1	,	0	,	0	,
                   1	,	0	,	-1	,	0	,	0	,	-1	,	1	,	0	,	0	,
                   1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,	0	,
                   -1	,	0	,	1	,	0	,	0	,	1	,	1	,	0	,	0	,
                   -1	,	0	,	1	,	0	,	0	,	1	,	-1	,	0	,	0	,
                   -1	,	0	,	1	,	0	,	0	,	-1	,	1	,	0	,	0	,
                   -1	,	0	,	1	,	0	,	0	,	-1	,	-1	,	0	,	0	,
                   -1	,	0	,	-1	,	0	,	0	,	1	,	1	,	0	,	0	,
                   -1	,	0	,	-1	,	0	,	0	,	1	,	-1	,	0	,	0	,
                   -1	,	0	,	-1	,	0	,	0	,	-1	,	1	,	0	,	0	,
                   -1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,	0	,
                   0	,	1	,	0	,	1	,	0	,	0	,	1	,	1	,	0	,
                   0	,	1	,	0	,	1	,	0	,	0	,	1	,	-1	,	0	,
                   0	,	1	,	0	,	1	,	0	,	0	,	-1	,	1	,	0	,
                   0	,	1	,	0	,	1	,	0	,	0	,	-1	,	-1	,	0	,
                   0	,	1	,	0	,	-1	,	0	,	0	,	1	,	1	,	0	,
                   0	,	1	,	0	,	-1	,	0	,	0	,	1	,	-1	,	0	,
                   0	,	1	,	0	,	-1	,	0	,	0	,	-1	,	1	,	0	,
                   0	,	1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,
                   0	,	-1	,	0	,	1	,	0	,	0	,	1	,	1	,	0	,
                   0	,	-1	,	0	,	1	,	0	,	0	,	1	,	-1	,	0	,
                   0	,	-1	,	0	,	1	,	0	,	0	,	-1	,	1	,	0	,
                   0	,	-1	,	0	,	1	,	0	,	0	,	-1	,	-1	,	0	,
                   0	,	-1	,	0	,	-1	,	0	,	0	,	1	,	1	,	0	,
                   0	,	-1	,	0	,	-1	,	0	,	0	,	1	,	-1	,	0	,
                   0	,	-1	,	0	,	-1	,	0	,	0	,	-1	,	1	,	0	,
                   0	,	-1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,
                   0	,	0	,	1	,	0	,	1	,	0	,	0	,	1	,	1	,
                   0	,	0	,	1	,	0	,	1	,	0	,	0	,	1	,	-1	,
                   0	,	0	,	1	,	0	,	1	,	0	,	0	,	-1	,	1	,
                   0	,	0	,	1	,	0	,	1	,	0	,	0	,	-1	,	-1	,
                   0	,	0	,	1	,	0	,	-1	,	0	,	0	,	1	,	1	,
                   0	,	0	,	1	,	0	,	-1	,	0	,	0	,	1	,	-1	,
                   0	,	0	,	1	,	0	,	-1	,	0	,	0	,	-1	,	1	,
                   0	,	0	,	1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,
                   0	,	0	,	-1	,	0	,	1	,	0	,	0	,	1	,	1	,
                   0	,	0	,	-1	,	0	,	1	,	0	,	0	,	1	,	-1	,
                   0	,	0	,	-1	,	0	,	1	,	0	,	0	,	-1	,	1	,
                   0	,	0	,	-1	,	0	,	1	,	0	,	0	,	-1	,	-1	,
                   0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	1	,	1	,
                   0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	1	,	-1	,
                   0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	-1	,	1	,
                   0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,
                   1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,	1	,
                   -1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,	1	,
                   1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,	-1	,
                   -1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,	-1	,
                   1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,	1	,
                   -1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,	1	,
                   1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,	-1	,
                   -1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,	-1	,
                   1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,	1	,
                   -1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,	1	,
                   1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,	-1	,
                   -1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,	-1	,
                   1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	1	,
                   -1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	1	,
                   1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	-1	,
                   -1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	-1	,
                   1	,	1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,
                   1	,	-1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,
                   -1	,	1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,
                   -1	,	-1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,
                   1	,	1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,
                   1	,	-1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,
                   -1	,	1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,
                   -1	,	-1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,
                   1	,	1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,
                   1	,	-1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,
                   -1	,	1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,
                   -1	,	-1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,
                   1	,	1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,
                   1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,
                   -1	,	1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,
                   -1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,
                   0	,	1	,	1	,	0	,	0	,	1	,	0	,	1	,	0	,
                   0	,	1	,	-1	,	0	,	0	,	1	,	0	,	1	,	0	,
                   0	,	-1	,	1	,	0	,	0	,	1	,	0	,	1	,	0	,
                   0	,	-1	,	-1	,	0	,	0	,	1	,	0	,	1	,	0	,
                   0	,	1	,	1	,	0	,	0	,	1	,	0	,	-1	,	0	,
                   0	,	1	,	-1	,	0	,	0	,	1	,	0	,	-1	,	0	,
                   0	,	-1	,	1	,	0	,	0	,	1	,	0	,	-1	,	0	,
                   0	,	-1	,	-1	,	0	,	0	,	1	,	0	,	-1	,	0	,
                   0	,	1	,	1	,	0	,	0	,	-1	,	0	,	1	,	0	,
                   0	,	1	,	-1	,	0	,	0	,	-1	,	0	,	1	,	0	,
                   0	,	-1	,	1	,	0	,	0	,	-1	,	0	,	1	,	0	,
                   0	,	-1	,	-1	,	0	,	0	,	-1	,	0	,	1	,	0	,
                   0	,	1	,	1	,	0	,	0	,	-1	,	0	,	-1	,	0	,
                   0	,	1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,	0	,
                   0	,	-1	,	1	,	0	,	0	,	-1	,	0	,	-1	,	0	,
                   0	,	-1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,	0	,
                   0	,	0	,	1	,	1	,	0	,	0	,	1	,	0	,	1	,
                   0	,	0	,	1	,	-1	,	0	,	0	,	1	,	0	,	1	,
                   0	,	0	,	-1	,	1	,	0	,	0	,	1	,	0	,	1	,
                   0	,	0	,	-1	,	-1	,	0	,	0	,	1	,	0	,	1	,
                   0	,	0	,	1	,	1	,	0	,	0	,	1	,	0	,	-1	,
                   0	,	0	,	1	,	-1	,	0	,	0	,	1	,	0	,	-1	,
                   0	,	0	,	-1	,	1	,	0	,	0	,	1	,	0	,	-1	,
                   0	,	0	,	-1	,	-1	,	0	,	0	,	1	,	0	,	-1	,
                   0	,	0	,	1	,	1	,	0	,	0	,	-1	,	0	,	1	,
                   0	,	0	,	1	,	-1	,	0	,	0	,	-1	,	0	,	1	,
                   0	,	0	,	-1	,	1	,	0	,	0	,	-1	,	0	,	1	,
                   0	,	0	,	-1	,	-1	,	0	,	0	,	-1	,	0	,	1	,
                   0	,	0	,	1	,	1	,	0	,	0	,	-1	,	0	,	-1	,
                   0	,	0	,	1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,
                   0	,	0	,	-1	,	1	,	0	,	0	,	-1	,	0	,	-1	,
                   0	,	0	,	-1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,
                   1	,	0	,	0	,	1	,	1	,	0	,	0	,	1	,	0	,
                   1	,	0	,	0	,	1	,	-1	,	0	,	0	,	1	,	0	,
                   1	,	0	,	0	,	-1	,	1	,	0	,	0	,	1	,	0	,
                   1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	1	,	0	,
                   -1	,	0	,	0	,	1	,	1	,	0	,	0	,	1	,	0	,
                   -1	,	0	,	0	,	1	,	-1	,	0	,	0	,	1	,	0	,
                   -1	,	0	,	0	,	-1	,	1	,	0	,	0	,	1	,	0	,
                   -1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	1	,	0	,
                   1	,	0	,	0	,	1	,	1	,	0	,	0	,	-1	,	0	,
                   1	,	0	,	0	,	1	,	-1	,	0	,	0	,	-1	,	0	,
                   1	,	0	,	0	,	-1	,	1	,	0	,	0	,	-1	,	0	,
                   1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	-1	,	0	,
                   -1	,	0	,	0	,	1	,	1	,	0	,	0	,	-1	,	0	,
                   -1	,	0	,	0	,	1	,	-1	,	0	,	0	,	-1	,	0	,
                   -1	,	0	,	0	,	-1	,	1	,	0	,	0	,	-1	,	0	,
                   -1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	-1	,	0	,
                   0	,	1	,	0	,	0	,	1	,	1	,	0	,	0	,	1	,
                   0	,	1	,	0	,	0	,	1	,	-1	,	0	,	0	,	1	,
                   0	,	1	,	0	,	0	,	-1	,	1	,	0	,	0	,	1	,
                   0	,	1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	1	,
                   0	,	-1	,	0	,	0	,	1	,	1	,	0	,	0	,	1	,
                   0	,	-1	,	0	,	0	,	1	,	-1	,	0	,	0	,	1	,
                   0	,	-1	,	0	,	0	,	-1	,	1	,	0	,	0	,	1	,
                   0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	1	,
                   0	,	1	,	0	,	0	,	1	,	1	,	0	,	0	,	-1	,
                   0	,	1	,	0	,	0	,	1	,	-1	,	0	,	0	,	-1	,
                   0	,	1	,	0	,	0	,	-1	,	1	,	0	,	0	,	-1	,
                   0	,	1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	-1	,
                   0	,	-1	,	0	,	0	,	1	,	1	,	0	,	0	,	-1	,
                   0	,	-1	,	0	,	0	,	1	,	-1	,	0	,	0	,	-1	,
                   0	,	-1	,	0	,	0	,	-1	,	1	,	0	,	0	,	-1	,
                   0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	-1	,
                   1	,	0	,	1	,	1	,	1	,	0	,	0	,	0	,	0	,
                   1	,	0	,	1	,	1	,	-1	,	0	,	0	,	0	,	0	,
                   1	,	0	,	1	,	-1	,	1	,	0	,	0	,	0	,	0	,
                   1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	0	,	0	,
                   1	,	0	,	-1	,	1	,	1	,	0	,	0	,	0	,	0	,
                   1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	0	,	0	,
                   1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	0	,	0	,
                   1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,	0	,
                   -1	,	0	,	1	,	1	,	1	,	0	,	0	,	0	,	0	,
                   -1	,	0	,	1	,	1	,	-1	,	0	,	0	,	0	,	0	,
                   -1	,	0	,	1	,	-1	,	1	,	0	,	0	,	0	,	0	,
                   -1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	0	,	0	,
                   -1	,	0	,	-1	,	1	,	1	,	0	,	0	,	0	,	0	,
                   -1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	0	,	0	,
                   -1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	0	,	0	,
                   -1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,	0	,
                   0	,	1	,	0	,	1	,	1	,	1	,	0	,	0	,	0	,
                   0	,	1	,	0	,	1	,	1	,	-1	,	0	,	0	,	0	,
                   0	,	1	,	0	,	1	,	-1	,	1	,	0	,	0	,	0	,
                   0	,	1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	0	,
                   0	,	1	,	0	,	-1	,	1	,	1	,	0	,	0	,	0	,
                   0	,	1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	0	,
                   0	,	1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	0	,
                   0	,	1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
                   0	,	-1	,	0	,	1	,	1	,	1	,	0	,	0	,	0	,
                   0	,	-1	,	0	,	1	,	1	,	-1	,	0	,	0	,	0	,
                   0	,	-1	,	0	,	1	,	-1	,	1	,	0	,	0	,	0	,
                   0	,	-1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	0	,
                   0	,	-1	,	0	,	-1	,	1	,	1	,	0	,	0	,	0	,
                   0	,	-1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	0	,
                   0	,	-1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	0	,
                   0	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
                   0	,	0	,	1	,	0	,	1	,	1	,	1	,	0	,	0	,
                   0	,	0	,	1	,	0	,	1	,	1	,	-1	,	0	,	0	,
                   0	,	0	,	1	,	0	,	1	,	-1	,	1	,	0	,	0	,
                   0	,	0	,	1	,	0	,	1	,	-1	,	-1	,	0	,	0	,
                   0	,	0	,	1	,	0	,	-1	,	1	,	1	,	0	,	0	,
                   0	,	0	,	1	,	0	,	-1	,	1	,	-1	,	0	,	0	,
                   0	,	0	,	1	,	0	,	-1	,	-1	,	1	,	0	,	0	,
                   0	,	0	,	1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,
                   0	,	0	,	-1	,	0	,	1	,	1	,	1	,	0	,	0	,
                   0	,	0	,	-1	,	0	,	1	,	1	,	-1	,	0	,	0	,
                   0	,	0	,	-1	,	0	,	1	,	-1	,	1	,	0	,	0	,
                   0	,	0	,	-1	,	0	,	1	,	-1	,	-1	,	0	,	0	,
                   0	,	0	,	-1	,	0	,	-1	,	1	,	1	,	0	,	0	,
                   0	,	0	,	-1	,	0	,	-1	,	1	,	-1	,	0	,	0	,
                   0	,	0	,	-1	,	0	,	-1	,	-1	,	1	,	0	,	0	,
                   0	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,
                   0	,	0	,	0	,	1	,	0	,	1	,	1	,	1	,	0	,
                   0	,	0	,	0	,	1	,	0	,	1	,	1	,	-1	,	0	,
                   0	,	0	,	0	,	1	,	0	,	1	,	-1	,	1	,	0	,
                   0	,	0	,	0	,	1	,	0	,	1	,	-1	,	-1	,	0	,
                   0	,	0	,	0	,	1	,	0	,	-1	,	1	,	1	,	0	,
                   0	,	0	,	0	,	1	,	0	,	-1	,	1	,	-1	,	0	,
                   0	,	0	,	0	,	1	,	0	,	-1	,	-1	,	1	,	0	,
                   0	,	0	,	0	,	1	,	0	,	-1	,	-1	,	-1	,	0	,
                   0	,	0	,	0	,	-1	,	0	,	1	,	1	,	1	,	0	,
                   0	,	0	,	0	,	-1	,	0	,	1	,	1	,	-1	,	0	,
                   0	,	0	,	0	,	-1	,	0	,	1	,	-1	,	1	,	0	,
                   0	,	0	,	0	,	-1	,	0	,	1	,	-1	,	-1	,	0	,
                   0	,	0	,	0	,	-1	,	0	,	-1	,	1	,	1	,	0	,
                   0	,	0	,	0	,	-1	,	0	,	-1	,	1	,	-1	,	0	,
                   0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,	1	,	0	,
                   0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,
                   0	,	0	,	0	,	0	,	1	,	0	,	1	,	1	,	1	,
                   0	,	0	,	0	,	0	,	1	,	0	,	1	,	1	,	-1	,
                   0	,	0	,	0	,	0	,	1	,	0	,	1	,	-1	,	1	,
                   0	,	0	,	0	,	0	,	1	,	0	,	1	,	-1	,	-1	,
                   0	,	0	,	0	,	0	,	1	,	0	,	-1	,	1	,	1	,
                   0	,	0	,	0	,	0	,	1	,	0	,	-1	,	1	,	-1	,
                   0	,	0	,	0	,	0	,	1	,	0	,	-1	,	-1	,	1	,
                   0	,	0	,	0	,	0	,	1	,	0	,	-1	,	-1	,	-1	,
                   0	,	0	,	0	,	0	,	-1	,	0	,	1	,	1	,	1	,
                   0	,	0	,	0	,	0	,	-1	,	0	,	1	,	1	,	-1	,
                   0	,	0	,	0	,	0	,	-1	,	0	,	1	,	-1	,	1	,
                   0	,	0	,	0	,	0	,	-1	,	0	,	1	,	-1	,	-1	,
                   0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	1	,	1	,
                   0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	1	,	-1	,
                   0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,	1	,
                   0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,
                   1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,	1	,
                   -1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,	1	,
                   1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,	-1	,
                   -1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,	-1	,
                   1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,	1	,
                   -1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,	1	,
                   1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,	-1	,
                   -1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,	-1	,
                   1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,	1	,
                   -1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,	1	,
                   1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,	-1	,
                   -1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,	-1	,
                   1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	1	,
                   -1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	1	,
                   1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
                   -1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
                   1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,
                   1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,
                   -1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,
                   -1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,
                   1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,
                   1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,
                   -1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,
                   -1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,
                   1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,
                   1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,
                   -1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,
                   -1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,
                   1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                   1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                   -1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                   -1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                   1	,	1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,
                   1	,	1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,
                   1	,	-1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,
                   1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,
                   -1	,	1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,
                   -1	,	1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,
                   -1	,	-1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,
                   -1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,
                   1	,	1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                   1	,	1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                   1	,	-1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                   1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                   -1	,	1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                   -1	,	1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                   -1	,	-1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                   -1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                   0	,	1	,	1	,	1	,	0	,	0	,	0	,	0	,	1	,
                   0	,	1	,	1	,	-1	,	0	,	0	,	0	,	0	,	1	,
                   0	,	1	,	-1	,	1	,	0	,	0	,	0	,	0	,	1	,
                   0	,	1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	1	,
                   0	,	-1	,	1	,	1	,	0	,	0	,	0	,	0	,	1	,
                   0	,	-1	,	1	,	-1	,	0	,	0	,	0	,	0	,	1	,
                   0	,	-1	,	-1	,	1	,	0	,	0	,	0	,	0	,	1	,
                   0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	1	,
                   0	,	1	,	1	,	1	,	0	,	0	,	0	,	0	,	-1	,
                   0	,	1	,	1	,	-1	,	0	,	0	,	0	,	0	,	-1	,
                   0	,	1	,	-1	,	1	,	0	,	0	,	0	,	0	,	-1	,
                   0	,	1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	-1	,
                   0	,	-1	,	1	,	1	,	0	,	0	,	0	,	0	,	-1	,
                   0	,	-1	,	1	,	-1	,	0	,	0	,	0	,	0	,	-1	,
                   0	,	-1	,	-1	,	1	,	0	,	0	,	0	,	0	,	-1	,
                   0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	-1	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                   0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	),nrow=291,byrow=T)

      # print(B2)

    }
    #########################

    Pred3.var<-function(matrix){
      matfA<-matrix
      mat1<-matrix(,nrow=nrow(matfA),ncol=0)
      p=1
      while(p<=v){
        x1<-matrix(,nrow=nrow(matfA),ncol=0)
        x1<-(matfA[,p])^2
        mat1<-cbind(mat1,x1)
        p=p+1
      }
      ############normal matrix
      #matfA
      ##########sq terms mat1
      #mat1
      ##############interactions
      b1=1
      b2=1
      mat12<-matrix(,nrow=nrow(matfA),ncol=0)
      while(b1<v){
        b2=b1+1
        while(b2<=v){
          mat2<-matrix(,nrow=0,ncol=1)
          mat2<-matfA[,b1]*matfA[,b2]
          mat12<-cbind(mat12,mat2)
          b2=b2+1
        }

        b1=b1+1

      }
      #########interactions
      #mat12
      ############tricky portion
      new<-matfA

      o=1
      while(o<=v){
        matt<-matrix(,nrow=nrow(mat1),ncol=0)
        matt<-mat1[,c(o)]
        mat11<-mat1[,-c(o)]
        mat11<-cbind(matt,mat11)
        changed<-cbind(new[,o],mat11)
        mat123<-matrix(,nrow=nrow(new),ncol=0)
        q=1
        while(q<ncol(changed)){

          x1<-matrix(,nrow=nrow(new),ncol=0)
          x1<-changed[,1]*changed[,q+1]
          mat123<-cbind(mat123,x1)
          q=q+1
        }
        mat12<-cbind(mat12,new[,o],mat123)
        o=o+1
      }
      #ncol(mat12)
      #################################checking


      #############3 factor interactions
      l1=1
      l2=1
      l3=1
      int<-matrix(,nrow=nrow(mat1),ncol=0)
      while(l1<=v-2){
        l2=l1+1

        while(l2<=v-1){
          l3=l2+1
          while(l3<=v){
            mat2<-matrix(,nrow=0,ncol=1)
            mat2<-matfA[,l1]*matfA[,l2]*matfA[,l3]
            int<-cbind(int,mat2)
            l3=l3+1
          }
          l2=l2+1
        }

        l1=l1+1

      }
      #ncol(int)
      #########################
      x_mat<-cbind(mat1,mat12,int)
      x_mat<-cbind((matrix(1,nrow=nrow(x_mat),ncol=1)),x_mat)
      rownames(x_mat)<-NULL
      colnames(x_mat)<-NULL
      x_prime_x<-t(x_mat)%*%x_mat
      ###############
      x_matrix<-x_mat
      k1=1
      var<-c()
      while(k1<=nrow(x_matrix))
      {
        V=t(x_matrix[k1,])
        b<-t(V)
        v_y_hat<-V %*%solve(x_prime_x) %*% b
        var<-c(var,v_y_hat)
        k1<-k1+1
      }
      variance_of_esitmated_response<-round(var,digits = 3 )
      lm=list("col"=ncol(x_matrix),"mvar"=max(variance_of_esitmated_response))
      return(lm)
    }
    #}#################
    N=nrow(rbind(B1,B2))
    p=Pred3.var(rbind(B1,B2))$"col"
    mvar=Pred3.var(rbind(B1,B2))$"mvar"
    #####
    G_eff=p/(mvar*N)
    ################################################
    lm=list("Block 1"=B1, "Block 2"=B2,"G efficiency"=G_eff)
    return(lm)
  }
  ###################################

  if(v==3){
    print("Please, select the levels for which design to be generated: 1)13,13,5  2)9,9,5",quote=F)
    cat("\n")
    print("Please enter the serial number among the combinations:",quote=F)
    levels=readline()
    if(levels==1){
      B<-matrix(c(0.866025404,0.5, 0 , -0.5 , 0.866025404, 0, 0, 0, 1),nrow=3,byrow=T)
    }
    if(levels==2){
      B<-matrix(c(0.31622777, 0.63245553, 0,  0.63245553, -0.31622777,0,0,0,1),nrow=3,byrow=T)
    }
    # z=rbind(SeqTORD(v)$"Block 1",SeqTORD(v)$"Block 2")
    # zb=z%*%B
    # return(round(zb,digits=3))
  }
  ###########################
  if(v==4){
    print("Please, select the levels for which design to be generated: 1)13,13,5,5  2)7,5,9,5 3)17,17,17,5  4)13,13,9,9",quote=F)
    print("Please enter in terms of serial number:",quote=F)
    levels=readline()
    if(levels==1){
      B<-matrix(c(0.6,	0.8,	0,	0, -0.8,	0.6,	0,	0, 0,	0,	1,	0, 0,	0, 0, 1),nrow=4,byrow=T)
    }
    if(levels==2){
      B<-matrix(c(0.577350269,	0.707106781,	0.40824829,	0,   0.577350269,
                  -0.707106781,	0.40824829,	0,  0.577350269,	0,	-0.816496581,	0,  0,	0,	0,	1	),nrow=4,byrow=T)

    }
    if(levels==3){
      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	0 ,-0.666666667,	0.666666667,	0.333333333,	0 ,   0.666666667,	0.333333333,	0.666666667,	0,
                  0,	0,	0,	1),nrow=4,byrow=T)

    }
    if(levels==4){
      B<-matrix(c(0.866025404,	0.500000000,	0,	0,
                  -0.5,	0.866025404,	0,	0,
                  0,	0,	0.316227766,	0.632455532,
                  0,	0,	0.632455532,	-0.316227766),nrow=4,byrow=T)

    }
    # z=rbind(SeqTORD(v)$"Block 1",SeqTORD(v)$"Block 2")
    # zb=z%*%B
    # return(round(zb,digits=3))
  }
  ###############
  if(v==5){
    print("Please, select the levels for which design to be generated: 1)13,13,5,5,5  2)11,11,11,5,5 3)13,13,9,9,5 4)7,5,17,17,5",quote=F)
    cat("\n")
    print("Please enter in terms of serial number:",quote=F)
    levels=readline()
    if(levels==1){
      B<-matrix(c(0.6,	 0.8,	0,	0,	0,
                  -0.8,	0.6,	0,	0,	0,
                  0,	0,	1,	0,	0,
                  0,	0,	0,	1,	0,
                  0,	0,	0,	0,	1
      ),nrow=5,byrow=T)

    }
    if(levels==2){

      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	0,	0,
                  -0.666666667,	0.666666667,	0.333333333,	0,	0,
                  0.666666667,	0.333333333,	0.666666667,	0,	0,
                  0,	0,	0,	1,	0,
                  0,	0,	0,	0,	1),nrow=5,byrow=T)

    }
    if(levels==3){
      B<-matrix(c(0.866025404,	0.500000000,	0,	0,	0,
                  -0.5,	0.866025404,	0,	0,	0,
                  0,	0,	0.316227766,	0.632455532,	0,
                  0,	0,	0.632455532,	-0.316227766,	0,
                  0,	0,	0,	0,	1),nrow=5,byrow=T)

    }
    if(levels==4){
      B<-matrix(c(0.5	, 0.707106781,	0.40824829,	0.288675135,	0,
                  0.5,	-0.707106781,	0.40824829,	0.288675135,	0,
                  0.5,	0,	-0.816496581,	0.288675135,	0,
                  0.5,	0,	0,	-0.866025404,	0,
                  0,	0,	0,	0,	1
      ),nrow=5,byrow=T)

    }
    # z=rbind(SeqTORD(v)$"Block 1",SeqTORD(v)$"Block 2")
    # zb=z%*%B
    # return(round(zb,digits=3))
  }
  ##########################
  if(v==6){
    print("Please, select the levels for which design to be generated: 1)13,13,5,5,5,5  2)9,7,13,5,5,5 3)9,5,17,21,5,5 4)17,17,17,9,9,5,5 ",quote=F)
    cat("\n")
    print("Please enter in terms of serial number:",quote=F)
    levels=readline()
    if(levels==1){
      B<-matrix(c(0.6, 	 0.8,	0,	0,	0,	0,
                  -0.8,	0.6,	0,	0,	0,	0,
                  0,	0,	1,	0,	0,	0,
                  0,	0,	0,	1,	0,	0,
                  0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	1),nrow=6,byrow=T)


    }
    if(levels==2){

      B<-matrix(c(0.577350269,	0.707106781,	0.40824829,	0,	0,	0,
                  0.577350269,	-0.707106781,	0.40824829,	0,	0,	0,
                  0.577350269,	0,	-0.816496581,	0,	0,	0,
                  0,	0,	0,	1,	0,	0,
                  0,	0,	0,	0,	0,	0,
                  0,	0,	0,	0,	0,	1),nrow=6,byrow=T)


    }
    if(levels==3){
      B<-matrix(c(0.5	, 0.707106781,	0.40824829,	0.288675135,	0,	0,
                  0.5,	-0.707106781,	0.40824829,	0.288675135,	0,	0,
                  0.5,	0,	-0.816496581,	0.288675135,	0,	0,
                  0.5,	0,	0,	-0.866025404,	0,	0,
                  0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	1),nrow=6,byrow=T)


    }
    if(levels==4){
      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	0,	0,	0,
                  -0.666666667,	0.666666667,	0.333333333,	0,	0,	0,
                  0.666666667,	0.333333333,	0.666666667,	0,	0,	0,
                  0,	0,	0,	0.316227766,	0.632455532,	0,
                  0,	0,	0,	0.632455532,	-0.316227766,	0,
                  0,	0,	0,	0,	0,	1),nrow=6,byrow=T)


    }
    # z=rbind(SeqTORD(v)$"Block 1",SeqTORD(v)$"Block 2")
    # zb=z%*%B
    # return(round(zb,digits=3))
  }
  ###############################################################
  if(v==7){
    print("Please, select the levels for which design to be generated: 1)15,15,15,13,13,5,5  2)15,15,15,9,11,7,5 3)9,7,19,19,13,13,5 4)13,13,11,11,11,11,5 ",quote=F)
    cat("\n")
    print("Please enter in terms of serial number:",quote=F)
    levels=readline()
    if(levels==1){
      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	0,	0,	0,	0,
                  -0.666666667,	0.666666667,	0.333333333,	0,	0,	0,	0,
                  0.666666667,	0.333333333,	0.666666667,	0,	0,	0,	0,
                  0,	0,	0,	0.6,	0.8,	0,	0,
                  0,	0,	0,	-0.8,	0.6,	0,	0,
                  0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	1),nrow=7,byrow=T)



    }
    if(levels==2){

      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	 0,	0,	0,	0,
                  -0.666666667,	 0.666666667,	 0.333333333,	 0,	0,	0,	0,
                  0.666666667,	0.333333333,	0.666666667,	0,	0,	0,	0,
                  0,	0,	0,	0.577350269,	0.707106781,	0.40824829,	0,
                  0,	0,	0,	0.577350269,	-0.707106781,	0.40824829,	0,
                  0,	0,	0,	0.577350269,	0,	-0.816496581,	0,
                  0,	0,	0,	0,	0,	0,	1	),nrow=7,byrow=T)



    }
    if(levels==3){
      B<-matrix(c(0.5,	0.707106781,	0.40824829,	0.288675135,	0,	0,	0,
                  0.5,	-0.707106781,	 0.40824829,	0.288675135,	0,	0,	0,
                  0.5,	0,	-0.816496581,	 0.288675135,	0,	0,	0,
                  0.5,	0,	0,	-0.866025404,	0,	0,	0,
                  0,	0,	0,	0,	0.6,	0.8,	0,
                  0,	0,	0,	0,	-0.8,	0.6,	0,
                  0,	0,	0,	0,	0,	0,	1),nrow=7,byrow=T)



    }
    if(levels==4){
      B<-matrix(c(0.6	,  0.8,	0,	0,	0,	0,	0,
                  -0.8,	0.6,	0,	0,	0,	0,	0,
                  0,	0,	0.316227766,	0.632455532,	0,	0,	0,
                  0,	0,	0.632455532,	-0.316227766,	0,	0,	0,
                  0,	0,	0,	0,	0.316227766,	0.632455532,	0,
                  0,	0,	0,	0,	0.632455532,	-0.316227766,		0,
                  0,	0,	0,	0,	0,	0,	1),nrow=7,byrow=T)



    }
    # z=rbind(SeqTORD(v)$"Block 1",SeqTORD(v)$"Block 2")
    # zb=z%*%B
    # return(round(zb,digits=3))
  }
  #####################################
  if(v==8){
    print("Please, select the levels for which design to be generated: 1)13,13,5,5,5,5,5,5  2)11,11,11,9,9,5,5,5 3)9,7,11,9,11,7,5,5 ",quote=F)
    cat("\n")
    print("Please enter in terms of serial number:",quote=F)
    levels=readline()
    if(levels==1){
      B<-matrix(c(0.6,	0.8,	0,	0,	0,	0,	0,	0,
                  -0.8,	0.6,	0,	0,	0,	0,	0,	0,
                  0,	0,	1,	0,	0,	0,	0,	0,
                  0,	0,	0,	1,	0,	0,	0,	0,
                  0,	0,	0,	0,	1,	0,	0,	0,
                  0,	0,	0,	0,	0,	1,	0,	0,
                  0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	1
      ),nrow=8,byrow=T)



    }
    if(levels==2){

      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	0,	0,	0,	0,	0,
                  -0.666666667,	0.666666667,	0.333333333,	0,	0,	0,	0,	0,
                  0.666666667,	0.333333333,	0.666666667,	0,	0,	0,	0,	0,
                  0,	0,	0,	0.6,	0.8,	0,	0,	0,
                  0,	0,	0,	-0.8,	0.6,	0,	0,	0,
                  0,	0,	0,	0,	0,	1,	0,	0,
                  0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	1),nrow=8,byrow=T)




    }
    if(levels==3){
      B<-matrix(c(0.333333333,	0,	-0.942809042, 	0,	0,	0,	0,	0,
                  0.666666667,	0.707106781,	0.23570226,	0,	0,	0,	0,	0,
                  0.666666667,	-0.707106781,	0.23570226,	0,	0,	0,	0,	0,
                  0,	0,	0,	0.333333333,	0,	-0.942809042,	0,	0,
                  0,	0,	0,	0.666666667,	0.707106781,	0.23570226,	0,	0,
                  0,	0,	0,	0.666666667,	-0.707106781,	0.23570226,	0,	0,
                  0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	1	),nrow=8,byrow=T)




    }
    # z=rbind(SeqTORD(v)$"Block 1",SeqTORD(v)$"Block 2")
    # zb=z%*%B
    # return(round(zb,digits=3))
  }
  ####################################

  if(v==9){
    print("Please, select the levels for which design to be generated: 1)13,13,5,5,5,5,5,5,5  2)9,7,13,9,7,13,5,5,5 3)11,7,13,17,9,7,13,5,5 ",quote=F)
    cat("\n")
    print("Please enter in terms of serial number:",quote=F)
    levels=readline()
    if(levels==1){
      B<-matrix(c(0.6,	0.8,	0,	0,	0,	0,	0,	0,	0,
                  -0.8,	0.6,	0,	0,	0,	0,	0,	0,	0,
                  0,	0,	1,	0,	0,	0,	0,	0,	0,
                  0,	0,	0,	1,	0,	0,	0,	0,	0,
                  0,	0,	0,	0,	1,	0,	0,	0,	0,
                  0,	0,	0,	0,	0,	1,	0,	0,	0,
                  0,	0,	0,	0,	0,	0,	1,	0,	0,
                  0,	0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	0,	1),nrow=9,byrow=T)




    }
    if(levels==2){

      B<-matrix(c(0.333333333,	0,	-0.942809042,	0,	0,	0,	0,	0,	0,
                  0.666666667,	0.707106781,	0.23570226,	0,	0,	0,	0,	0,	0,
                  0.666666667,	-0.707106781,	0.23570226,	0,	0,	0,	0,	0,	0,
                  0,	0,	0,	0.333333333,	0,	-0.942809042,	0,	0,	0,
                  0,	0,	0,	0.666666667,	0.707106781,	0.23570226,	0,	0,	0,
                  0,	0,	0,	0.666666667,	-0.707106781,	0.23570226,	0,	0,	0,
                  0,	0,	0,	0,	0,	0,	1,	0,	0,
                  0,	0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	0,	1	),nrow=9,byrow=T)





    }
    if(levels==3){
      B<-matrix(c(0.5, 0.707106781,	0.40824829,	0.288675135,	0,	0,	0,	0,	0,
                  0.5,	-0.707106781,	0.40824829,	0.288675135,	0,	0,	0,	0,	0,
                  0.5,	0,	-0.816496581,	0.288675135,	0,	0,	0,	0,	0,
                  0.5,	0,	0,	-0.866025404,	0,	0,	0,	0,	0,
                  0,	0,	0,	0,	0.333333333,	0,	-0.942809042,	0,	0,
                  0,	0,	0,	0,	0.666666667,	0.707106781,	0.23570226,	0,	0,
                  0,	0,	0,	0,	0.666666667,	-0.707106781,	0.23570226,	0,	0,
                  0,	0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	0,	1	),nrow=9,byrow=T)

    }
  }
  z=SeqTORD(v)$`Block 2`
  zb=z%*%B
  zb=round(zb,digits=5)
  mat1=SeqTORD(v)$`Block 1`
  mat1=mat1%*%B
  mat1=round(mat1,digits=5)
  #############################
  Pred3.var<-function(matrix){
    matfA<-matrix
    mat1<-matrix(,nrow=nrow(matfA),ncol=0)
    p=1
    while(p<=v){
      x1<-matrix(,nrow=nrow(matfA),ncol=0)
      x1<-(matfA[,p])^2
      mat1<-cbind(mat1,x1)
      p=p+1
    }
    ############normal matrix
    #matfA
    ##########sq terms mat1
    #mat1
    ##############interactions
    b1=1
    b2=1
    mat12<-matrix(,nrow=nrow(matfA),ncol=0)
    while(b1<v){
      b2=b1+1
      while(b2<=v){
        mat2<-matrix(,nrow=0,ncol=1)
        mat2<-matfA[,b1]*matfA[,b2]
        mat12<-cbind(mat12,mat2)
        b2=b2+1
      }

      b1=b1+1

    }
    #########interactions
    #mat12
    ############tricky portion
    new<-matfA

    o=1
    while(o<=v){
      matt<-matrix(,nrow=nrow(mat1),ncol=0)
      matt<-mat1[,c(o)]
      mat11<-mat1[,-c(o)]
      mat11<-cbind(matt,mat11)
      changed<-cbind(new[,o],mat11)
      mat123<-matrix(,nrow=nrow(new),ncol=0)
      q=1
      while(q<ncol(changed)){

        x1<-matrix(,nrow=nrow(new),ncol=0)
        x1<-changed[,1]*changed[,q+1]
        mat123<-cbind(mat123,x1)
        q=q+1
      }
      mat12<-cbind(mat12,new[,o],mat123)
      o=o+1
    }
    #ncol(mat12)
    #################################checking


    #############3 factor interactions
    l1=1
    l2=1
    l3=1
    int<-matrix(,nrow=nrow(mat1),ncol=0)
    while(l1<=v-2){
      l2=l1+1

      while(l2<=v-1){
        l3=l2+1
        while(l3<=v){
          mat2<-matrix(,nrow=0,ncol=1)
          mat2<-matfA[,l1]*matfA[,l2]*matfA[,l3]
          int<-cbind(int,mat2)
          l3=l3+1
        }
        l2=l2+1
      }

      l1=l1+1

    }
    #ncol(int)
    #########################
    x_mat<-cbind(mat1,mat12,int)
    x_mat<-cbind((matrix(1,nrow=nrow(x_mat),ncol=1)),x_mat)
    rownames(x_mat)<-NULL
    colnames(x_mat)<-NULL
    x_prime_x<-t(x_mat)%*%x_mat
    ###############
    x_matrix<-x_mat
    k1=1
    var<-c()
    while(k1<=nrow(x_matrix))
    {
      V=t(x_matrix[k1,])
      b<-t(V)
      v_y_hat<-V %*%solve(x_prime_x) %*% b
      var<-c(var,v_y_hat)
      k1<-k1+1
    }
    variance_of_esitmated_response<-round(var,digits = 3 )
    lm=list("col"=ncol(x_matrix),"mvar"=max(variance_of_esitmated_response))
    return(lm)
  }
  #}#################
  N=nrow(rbind(mat1,zb))
  p=Pred3.var(rbind(mat1,zb))$"col"
  mvar=Pred3.var(rbind(mat1,zb))$"mvar"
  #####
  G_eff=p/(mvar*N)
  G_eff=round(G_eff,digits = 5)
###########3
  mat1=round(mat1,digits=5)
  zb=round(zb,digits=5)
  mat1=format(mat1,nsmall=5)
  mat1=noquote(mat1)
  zb=format(zb,nsmall=5)
  zb=noquote(zb)
  ##############################################################################
  message("Asymmetric Sequential Third Order Design")
  cat("\n")
  message("Block 1")
  print(mat1)
  cat("\n")
  message("Block 2")
  print(zb)
  cat("\n")
  message("G-efficieny")
  print(G_eff)
  # listp=list("Block 1"=mat1, "Block 2"=zb,"G-efficieny"=G_eff)
  # return(listp)
}



