% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATORDs_I.R
\name{ATORDs_I}
\alias{ATORDs_I}
\title{Asymmetric Third Order Rotatable Designs based on Third Order Designs given by Das and Narasimham (1962)}
\usage{
ATORDs_I(v)
}
\arguments{
\item{v}{Number of input factors}
}
\value{
Asymmetric Third Order Rotatable Designs (ATORDs) for a given v.
}
\description{
Generates asymmetric third order rotatable designs based on third order designs given by Das and Narasimham (1962) for a given number of input factors, v (3<=v<=9) with coded levels of the factors.
}
\details{
The user is given two options for design generation. Method 1 generates asymmetric third order rotatable designs based on the third order designs given by Das and Narasimham (1962) for a given number of input factors, while method 2 generates asymmetric third order rotatable designs in a smaller number of runs as compared to the design generated by method 1, however, the variances of estimated parameters of the same order may not remain the same in case of design generated by method 2. After entering the serial number of any of the methods from the displayed set, the design from the chosen method will be generated and displayed.
}
\note{
The user is given with a set of mixed level response surface designs and after entering the serial number of any of the designs from the displayed set, the chosen design will be generated and displayed.
}
\examples{
if(interactive()){
library(MixedLevelRSDs)
ATORDs_I(3)}
}
\references{
1) J.S. Mehta and M.N. Das (1968). "Asymmetric rotatable designs and orthogonal transformations".

2) M. N. Das, V. Narasimham (1962). < doi:10.1214/AOMS/1177704374>. "Construction of Rotatable Designs Through Balanced Incomplete Block Designs".

3) M. Hemavathi, Shashi Shekhar, Eldho Varghese, Seema Jaggi, Bikas Sinha & Nripes Kumar Mandal (2022)<doi: 10.1080/03610926.2021.1944213>. "Theoretical developments in response surface designs: an informative review and further thoughts".
}
