% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Asymseq.R
\name{Asymseq}
\alias{Asymseq}
\title{Asymmetric Third Order Designs for sequential experimentation}
\usage{
Asymseq(v)
}
\arguments{
\item{v}{Total number of input factors}
}
\value{
Third order design in two blocks
}
\description{
Generates asymmetric sequential third order design for v  (3 <= v <= 9) factors in two blocks. Block I gives a second order design for the first stage of the experimentation. If lack of fit of the second order model is found to be significant, then further experimentation can be done with the design given in block II. Runs from block-I and block-II combined form a third order design. It also gives G-efficiency of the third order design.
}
\note{
The user is given with a set of mixed level response surface designs and after entering the serial number of any of the designs from the displayed set, the chosen design will be generated and displayed.
}
\examples{
if(interactive()){
library(MixedLevelRSDs)
Asymseq(4)
}
}
\references{
1)	G.E.P. Box and K.B. Wilson (1951). " On the experimental attainment of optimum conditions".

2)	 J.S. Mehta and M.N. Das (1968). "Asymmetric rotatable designs and orthogonal transformations".

3)	M. Hemavathi, Shashi Shekhar, Eldho Varghese, Seema Jaggi, Bikas Sinha & Nripes Kumar   Mandal (2022)<doi: 10.1080/03610926.2021.1944213>." Theoretical developments in response surface designs: an informative review and further thoughts".

4)	M. Hemavathi, Eldho Varghese, Shashi Shekhar & Seema Jaggi (2020) <doi: 10.1080/02664763.2020.1864817>. "Sequential asymmetric third order rotatable designs (SATORDs)".
}
