% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeqTORD.R
\name{SeqTORD}
\alias{SeqTORD}
\title{Symmetric Third Order Designs for sequential experimentation}
\usage{
SeqTORD(v)
}
\arguments{
\item{v}{Total number of input factors}
}
\value{
Third Order Design in two blocks along with G-efficiency
}
\description{
Generates symmetric sequential Third Order Design with v (3<=v<=9) factors in two blocks. Block I gives a second order design for the first stage of the experimentation. If lack of fit of the second order model is found to be significant, then further experimentation can be done with the design given in block II. Runs from block-I and block-II combined form a third order design. It also gives G-efficiency of the third order design.
}
\examples{
library(MixedLevelRSDs)
SeqTORD(4)
}
\references{
1) G.E.P. Box and K.B. Wilson (1951). " On the experimental attainment of optimum conditions".

 2) M. Hemavathi, Shashi Shekhar, Eldho Varghese, Seema Jaggi, Bikas Sinha & Nripes Kumar Mandal (2022)<doi: 10.1080/03610926.2021.1944213>.
 "Theoretical developments in response surface designs: an informative review and further thoughts".

 3) M. Hemavathi, Eldho Varghese, Shashi Shekhar & Seema Jaggi (2020) <doi: 10.1080/02664763.2020.1864817>. "Sequential asymmetric third order rotatable designs (SATORDs) ".
}
