% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.dendrogram.heatmap.R
\name{get.dendrogram.heatmap}
\alias{get.dendrogram.heatmap}
\title{Dendrogram Heatmap}
\usage{
get.dendrogram.heatmap(
  population,
  path = NULL,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  method = NULL,
  individual.names = NULL,
  traits = NULL,
  type = "pheno"
)
}
\arguments{
\item{population}{Population list}

\item{path}{provide a path if the dendrogram would be saved as a png-file}

\item{database}{Groups of individuals to consider}

\item{gen}{Quick-insert for database (vector of all generations to consider)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to consider)}

\item{id}{Individual IDs to search/collect in the database}

\item{method}{Method used to calculate genetic distances (default: "Nei", alt: "Rogers", "Prevosti", "Modified Rogers"}

\item{individual.names}{Names of the individuals in the database ((default are MoBPS internal names based on position))}

\item{traits}{Traits to include in the dendrogram (default: all traits)}

\item{type}{Which traits values to consider (default: "pheno", alt: "bv", "bve")}
}
\value{
Dendrogram plot of genotypes vs phenotypes
}
\description{
Function calculate a dendrogram heat
}
\examples{
population <- creating.diploid(nsnp=1000, nindi=40, n.additive = c(100,100,100),
               trait.cor = matrix(c(1,0.8,0.2,0.8,1,0.2,0.2,0.2,1), ncol=3), shuffle.traits = 1:3)
population <- breeding.diploid(population, phenotyping = "all", heritability = 0.5)
get.dendrogram.heatmap(population, gen=1, type="pheno")
}
