% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recalculate.bv.R
\name{recalculate.bv}
\alias{recalculate.bv}
\title{Recalculate genomic values}
\usage{
recalculate.bv(
  population,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  bv.ignore.traits = NULL,
  store.comp.times = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{database}{Groups of individuals to consider for the export}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{bv.ignore.traits}{Vector of traits to ignore in the calculation of the genomic value (default: NULL; Only recommended for high number of traits and experienced users!)}

\item{store.comp.times}{If TRUE store computation times in $info$comp.times.general (default: TRUE)}
}
\value{
Population list
}
\description{
Function to recalculate genomic values
}
\examples{
data(ex_pop)
population <- recalculate.bv(ex_pop, gen=2)
}
