% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplusModel.R
\name{mplusModel_r6}
\alias{mplusModel_r6}
\title{mplusModel R6 class}
\description{
An R6 class for a single Mplus model
}
\details{
Wrapped by \code{mplusModel}
}
\keyword{internal}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{model_dir}}{the directory for Mplus files corresponding to this model}

\item{\code{inp_file}}{the location of the Mplus .inp file for this model}

\item{\code{out_file}}{the location of the Mplus .out file for this model}

\item{\code{dat_file}}{the location of the Mplus .dat (data) file for this model}

\item{\code{data}}{the dataset used for estimating this model}

\item{\code{Mplus_command}}{the location of the Mplus program}

\item{\code{syntax}}{the Mplus syntax for this model as a character vector}

\item{\code{input}}{Read-only accessor for the \code{input} section returned by \code{readModels()}.}

\item{\code{warnings}}{Read-only accessor for the \code{warnings} section returned by \code{readModels()}.}

\item{\code{errors}}{Read-only accessor for the \code{errors} section returned by \code{readModels()}.}

\item{\code{data_summary}}{Read-only accessor for the \code{data_summary} section returned by \code{readModels()}.}

\item{\code{sampstat}}{Read-only accessor for the \code{sampstat} section returned by \code{readModels()}.}

\item{\code{covariance_coverage}}{Read-only accessor for the \code{covariance_coverage} section returned by \code{readModels()}.}

\item{\code{summaries}}{Read-only accessor for the \code{summaries} section returned by \code{readModels()}.}

\item{\code{invariance_testing}}{Read-only accessor for the \code{invariance_testing} section returned by \code{readModels()}.}

\item{\code{parameters}}{Read-only accessor for the \code{parameters} section returned by \code{readModels()}.}

\item{\code{class_counts}}{Read-only accessor for the \code{class_counts} section returned by \code{readModels()}.}

\item{\code{indirect}}{Read-only accessor for the \code{indirect} section returned by \code{readModels()}.}

\item{\code{mod_indices}}{Read-only accessor for the \code{mod_indices} section returned by \code{readModels()}.}

\item{\code{residuals}}{Read-only accessor for the \code{residuals} section returned by \code{readModels()}.}

\item{\code{savedata}}{Read-only accessor for the \code{savedata} section returned by \code{readModels()}.}

\item{\code{savedata_info}}{Read-only accessor for the \code{savedata_info} section returned by \code{readModels()}.}

\item{\code{bparameters}}{Read-only accessor for the \code{bparameters} section returned by \code{readModels()}.}

\item{\code{tech1}}{Read-only accessor for the \code{tech1} section returned by \code{readModels()}.}

\item{\code{tech3}}{Read-only accessor for the \code{tech3} section returned by \code{readModels()}.}

\item{\code{tech4}}{Read-only accessor for the \code{tech4} section returned by \code{readModels()}.}

\item{\code{tech7}}{Read-only accessor for the \code{tech7} section returned by \code{readModels()}.}

\item{\code{tech8}}{Read-only accessor for the \code{tech8} section returned by \code{readModels()}.}

\item{\code{tech9}}{Read-only accessor for the \code{tech9} section returned by \code{readModels()}.}

\item{\code{tech10}}{Read-only accessor for the \code{tech10} section returned by \code{readModels()}.}

\item{\code{tech12}}{Read-only accessor for the \code{tech12} section returned by \code{readModels()}.}

\item{\code{tech15}}{Read-only accessor for the \code{tech15} section returned by \code{readModels()}.}

\item{\code{fac_score_stats}}{Read-only accessor for the \code{fac_score_stats} section returned by \code{readModels()}.}

\item{\code{lcCondMeans}}{Read-only accessor for the \code{lcCondMeans} section returned by \code{readModels()}.}

\item{\code{r3step}}{Read-only accessor for the \code{r3step} section returned by \code{readModels()}.}

\item{\code{gh5}}{Read-only accessor for the \code{gh5} section returned by \code{readModels()}.}

\item{\code{h5results}}{Read-only accessor for the \code{h5results} section returned by \code{readModels()}.}

\item{\code{output}}{Read-only accessor for the \code{output} section returned by \code{readModels()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-mplusModel_r6-new}{\code{mplusModel_r6$new()}}
\item \href{#method-mplusModel_r6-read}{\code{mplusModel_r6$read()}}
\item \href{#method-mplusModel_r6-write_dat}{\code{mplusModel_r6$write_dat()}}
\item \href{#method-mplusModel_r6-write_inp}{\code{mplusModel_r6$write_inp()}}
\item \href{#method-mplusModel_r6-submit}{\code{mplusModel_r6$submit()}}
\item \href{#method-mplusModel_r6-run}{\code{mplusModel_r6$run()}}
\item \href{#method-mplusModel_r6-clone}{\code{mplusModel_r6$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mplusModel_r6-new"></a>}}
\if{latex}{\out{\hypertarget{method-mplusModel_r6-new}{}}}
\subsection{Method \code{new()}}{
generate an mplusModel_r6 object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mplusModel_r6$new(
  syntax = NULL,
  data = NULL,
  inp_file = NULL,
  read = TRUE,
  Mplus_command = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{syntax}}{a character vector of Mplus input syntax for this model}

\item{\code{data}}{a data.frame to be used for estimating the model}

\item{\code{inp_file}}{the location of .inp file for this model}

\item{\code{read}}{If TRUE and the .out file already exists, read the contents of the .out file using \code{readModels}}

\item{\code{Mplus_command}}{N.B.: No need to pass this parameter for most users (has intelligent defaults). Allows the user to
specify the name/path of the Mplus executable to be used for running models. This covers situations where Mplus
is not in the system's path, or where one wants to test different versions of the Mplus program.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mplusModel_r6-read"></a>}}
\if{latex}{\out{\hypertarget{method-mplusModel_r6-read}{}}}
\subsection{Method \code{read()}}{
read the results of an Mplus model from the .out file using \code{readModels}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mplusModel_r6$read(force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{force}}{if \code{TRUE}, re-read the .out file even if was already previously loaded in to this object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mplusModel_r6-write_dat"></a>}}
\if{latex}{\out{\hypertarget{method-mplusModel_r6-write_dat}{}}}
\subsection{Method \code{write_dat()}}{
write the .inp and .dat files for this model to the intended location
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mplusModel_r6$write_dat(overwrite = TRUE, quiet = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{overwrite}}{if \code{TRUE}, overwrite existing data. Default: \code{TRUE}.}

\item{\code{quiet}}{if \code{TRUE}, do not produce messages about the outcome of this command (e.g., a message about overwriting existing data)}

\item{\code{...}}{additional arguments passed to \code{prepareMplusData}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mplusModel_r6-write_inp"></a>}}
\if{latex}{\out{\hypertarget{method-mplusModel_r6-write_inp}{}}}
\subsection{Method \code{write_inp()}}{
write the .inp and .dat files for this model to the intended location
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mplusModel_r6$write_inp(overwrite = TRUE, inp_file = NULL, quiet = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{overwrite}}{if \code{TRUE}, overwrite existing data. Default: \code{TRUE}.}

\item{\code{inp_file}}{The location of the input file to write. If NULL (default), use the \verb{$inp_file} of this object.}

\item{\code{quiet}}{if \code{TRUE}, do not produce messages about the outcome of this command (e.g., a message about overwriting existing data)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mplusModel_r6-submit"></a>}}
\if{latex}{\out{\hypertarget{method-mplusModel_r6-submit}{}}}
\subsection{Method \code{submit()}}{
submit this model for estimation on an HPC using \code{submitModels}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mplusModel_r6$submit(replaceOutfile = "modifiedDate", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{replaceOutfile}}{Currently supports three settings: "always", which runs all models, regardless of whether an output file for the model exists;
"never", which does not run any model that has an existing output file; and "modifiedDate", which only runs a model if the modified date for the input
file is more recent than the output file modified date (implying there have been updates to the model).}

\item{\code{...}}{additional arguments passed to \code{submitModels}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mplusModel_r6-run"></a>}}
\if{latex}{\out{\hypertarget{method-mplusModel_r6-run}{}}}
\subsection{Method \code{run()}}{
run this model locally using \code{runModels}. The method detects
changes in the data and input syntax and only rewrites the corresponding
files when updates are detected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mplusModel_r6$run(replaceOutfile = "modifiedDate", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{replaceOutfile}}{Currently supports three settings: "always", which runs all models, regardless of whether an output file for the model exists;
"never", which does not run any model that has an existing output file; and "modifiedDate", which only runs a model if the modified date for the input
file is more recent than the output file modified date (implying there have been updates to the model).}

\item{\code{...}}{additional arguments passed to \code{runModels}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mplusModel_r6-clone"></a>}}
\if{latex}{\out{\hypertarget{method-mplusModel_r6-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mplusModel_r6$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
