% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMuPETFlow.R
\name{runMuPETFlow}
\alias{runMuPETFlow}
\title{Run the MuPETFlow app}
\usage{
runMuPETFlow()
}
\value{
No return value, called for side effects.
}
\description{
This function launches the Shiny app included in MuPETFlow.
Once the application is launched, you can either:
\enumerate{
\item Load your experimental data.
\item Run an in-app example by clicking the 'Example' button.
}\if{html}{\out{
<br>
<br>Notes:
For the first case, selecting the channel where the data was acquired is mandatory.
If you choose the second, the tool will download the example files in a temporary file. This process requires internet connection and might take a few minutes. Then, the example channel `FL4-A` is automatically detected for demonstration purposes.
}}
}
\details{
After launching the app, you can follow the app flow, which is divided into three tabs: \emph{\strong{Peaks}}, \emph{\strong{Regression}} and \emph{\strong{Summary}}.  Below is a general description of the options available in each tab:
\subsection{Peaks}{
\itemize{
\item \strong{Select a sample (optional):} Allows visual exploration of individual samples if desired.
\item \strong{Adjust smoothing (optional):} Adjusts the histogram curve for noisy samples.
\item \strong{Adjust window width (optional):} Defines the interval where the app will look for peaks.
\item \strong{Select minimum cell count to call a peak (optional):} Useful for samples with a low number of events.
\item \strong{Select maximum number of peaks to plot (optional):} Useful for samples with heterogeneous populations where more peaks are present.
}
}

\subsection{Regression}{
\itemize{
\item \strong{Select type of analysis:} Choose between "Ploidy" or "Genome size" analysis.
\item \strong{Select number of standards:} A minimum of two different standards is required, but more are recommended.
\item \strong{Select standard samples and values:} This is the ploidy or genome size of your standards.
}
}

\subsection{Summary}{
\itemize{
\item \strong{Results preview:} Creates a compiled figure with histograms for all samples.
\item \strong{Save plot:} Saves the histograms in either PNG or TIFF format with customizable size and quality. Optionally, you can control the grid layout.
\item \strong{Save table:} Exports the parameters used and the estimated ploidy or genome size as a CSV file.
}\if{html}{\out{
<br>
If any errors are detected in the analyzed samples, you can go back to the Peaks tab to review the parameters. Note that the regression must also be re-done after parameter adjustments.
}}

}
}
\examples{
if (interactive()) {
  # Example: Check that the function exists and runs
  runMuPETFlow()
} else {
  message("This is a Shiny app wrapper. Run interactively to use.")
}
}
