% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputsForOpt.R
\name{GetPdynPara_BC}
\alias{GetPdynPara_BC}
\title{Compute P-dynamics parameters using the bias correction method from BRW (2012)}
\usage{
GetPdynPara_BC(
  ModelType,
  BRWinputs,
  RiskFactors,
  Economies,
  FactorLabels,
  GVARinputs,
  JLLinputs,
  verbose
)
}
\arguments{
\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{BRWinputs}{list of necessary inputs for performing the bias-corrected estimation (see "Bias_Correc_VAR" function)}

\item{RiskFactors}{time series of risk factors (F x T). Could be stored in a list depending on the model}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{FactorLabels}{string-list based which contains the labels of all variables present in the model}

\item{GVARinputs}{list of necessary inputs for the estimation of GVAR-based models (see "GVAR" function)}

\item{JLLinputs}{list of necessary inputs for the estimation of JLL-based models (see "JLL" function)}

\item{verbose}{Logical flag controlling function messaging.}
}
\description{
Compute P-dynamics parameters using the bias correction method from BRW (2012)
}
\keyword{internal}
