% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIR_prob.R
\name{SIR_prob}
\alias{SIR_prob}
\title{Transition probabilities of an SIR process}
\usage{
SIR_prob(t, alpha, beta, S0, I0, nSI, nIR, direction = c("Forward",
  "Backward"), nblocks = 20, tol = 1e-12, computeMode = 0, nThreads = 4)
}
\arguments{
\item{t}{time}

\item{alpha}{removal rate}

\item{beta}{infection rate}

\item{S0}{initial susceptible population}

\item{I0}{initial infectious population}

\item{nSI}{number of infection events}

\item{nIR}{number of removal events}

\item{direction}{direction of the transition probabilities (either \code{Forward} or \code{Backward})}

\item{nblocks}{number of blocks}

\item{tol}{tolerance}

\item{computeMode}{computation mode}

\item{nThreads}{number of threads}
}
\value{
a matrix of the transition probabilities
}
\description{
Computes the transition pobabilities of an SIR process 
using the bivariate birth process representation
}
\examples{
data(Eyam)

loglik_sir <- function(param, data) {
  alpha <- exp(param[1]) # Rates must be non-negative
  beta  <- exp(param[2])
  
  if(length(unique(rowSums(data[, c("S", "I", "R")]))) > 1) {
    stop ("Please make sure the data conform with a closed population")
  }
  
  sum(sapply(1:(nrow(data) - 1), # Sum across all time steps k
             function(k) {
               log(
                 SIR_prob(  # Compute the forward transition probability matrix
                   t  = data$time[k + 1] - data$time[k], # Time increment
                   alpha = alpha, beta = beta, 
                   S0 = data$S[k], I0 = data$I[k],       # From: R(t_k), I(t_k)
                   nSI = data$S[k] - data$S[k + 1], nIR = data$R[k + 1] - data$R[k],
                   computeMode = 4, nblocks = 80         # Compute using 4 threads
                 )[data$S[k] - data$S[k + 1] + 1, 
                   data$R[k + 1] - data$R[k] + 1]        # To: R(t_(k+1)), I(t_(k+1))
               )
             }))
}

loglik_sir(log(c(3.204, 0.019)), Eyam) # Evaluate at mode
}

